package cn.sexycode.springo.bpm.rest;

import cn.sexycode.springo.bo.manager.BoDefManager;
import cn.sexycode.springo.bo.model.BoDef;
import cn.sexycode.springo.bpm.api.constant.*;
import cn.sexycode.springo.bpm.api.core.context.BpmPluginContext;
import cn.sexycode.springo.bpm.api.def.BpmDefXmlHandler;
import cn.sexycode.springo.bpm.api.def.BpmDefinitionAccessor;
import cn.sexycode.springo.bpm.api.identity.UserQueryPluginHelper;
import cn.sexycode.springo.bpm.api.model.process.def.*;
import cn.sexycode.springo.bpm.api.model.process.nodedef.BpmNodeDef;
import cn.sexycode.springo.bpm.api.model.process.nodedef.JumpRule;
import cn.sexycode.springo.bpm.api.model.process.nodedef.ext.AutoTaskDef;
import cn.sexycode.springo.bpm.api.model.process.nodedef.ext.SignNodeDef;
import cn.sexycode.springo.bpm.api.model.process.nodedef.ext.SubProcessNodeDef;
import cn.sexycode.springo.bpm.api.model.process.nodedef.ext.UserTaskNodeDef;
import cn.sexycode.springo.bpm.api.model.process.nodedef.ext.extmodel.*;
import cn.sexycode.springo.bpm.api.service.BpmDefinitionService;
import cn.sexycode.springo.bpm.api.service.DiagramService;
import cn.sexycode.springo.bpm.util.HandlerUtil;
import cn.sexycode.springo.core.base.core.json.JSONArray;
import cn.sexycode.springo.core.base.core.json.JSONObject;
import cn.sexycode.springo.core.base.core.util.AppUtil;
import cn.sexycode.springo.core.base.core.util.BeanUtils;
import cn.sexycode.springo.core.base.core.util.MapBuilder;
import cn.sexycode.springo.core.base.core.util.string.StringUtil;
import cn.sexycode.springo.core.data.db.api.model.PageJson;
import cn.sexycode.springo.core.web.BaseController;
import cn.sexycode.springo.core.web.util.RequestUtil;
import cn.sexycode.springo.form.model.FormType;
import cn.sexycode.springo.form.model.IForm;
import cn.sexycode.springo.org.api.model.IUser;
import cn.sexycode.springo.org.api.service.IUserGroupService;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.*;

/**
 * <pre>
 * 描述：流程节点配置管理
 * </pre>
 */
@Controller
@RequestMapping("/flow/node/")
public class NodeController extends BaseController {
    @Resource
    BpmDefinitionService bpmDefinitionService;
    @Resource
    BpmDefinitionAccessor bpmDefinitionAccessor;
    @Resource
    private UserQueryPluginHelper userQueryPluginHelper;
    @Resource
    private IUserGroupService userGroupService;
    @Resource
    private BoDefManager bODefManager;
    @Resource
    DiagramService diagramService;

    /**
     * 编辑节点规则
     */
    @RequestMapping("ruleEdit")
    @ResponseBody
    public Object ruleEdit(String definitionId, String nodeId) {
        List<BpmNodeDef> nodeDefList = bpmDefinitionAccessor.getAllNodeDef(definitionId);
        UserTaskNodeDef nodeDef = (UserTaskNodeDef) bpmDefinitionService.getBpmNodeDefByDefIdNodeId(definitionId, nodeId);
        return new MapBuilder<>().put("nodeDef", nodeDef).put("nodeDefList", nodeDefList).put("processDefinitionId", definitionId).put("ruleList", nodeDef.getJumpRuleList());
    }

    /**
     * 节点规则列表
     */
    @RequestMapping("ruleListJson")
    public @ResponseBody
    PageJson ruleListJson(String definitionId, String nodeId) {
        UserTaskNodeDef nodeDef = (UserTaskNodeDef) bpmDefinitionService.getBpmNodeDefByDefIdNodeId(definitionId, nodeId);
        return new PageJson(Optional.of(nodeDef.getJumpRuleList()).orElse(new ArrayList<>()));
    }

    /**
     * 保存节点的跳转规则
     */
    @RequestMapping("ruleSave")
    public void ruleSave(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String resultMsg = null;
        String nodeId = RequestUtil.getString(request, "nodeId");
        String defId = RequestUtil.getString(request, "processDifinitionId");
        String rulesJson = RequestUtil.getString(request, "rules");

        List<JumpRule> jumpRuleList = JSONArray.toList(rulesJson, JumpRule.class);
        try {
            if (StringUtil.isNotEmpty(nodeId)) {
                BpmDefXmlHandler<List<JumpRule>> bpmDefXmlHandler = (BpmDefXmlHandler<List<JumpRule>>) AppUtil.getBean("transRulesBpmDefXmlHandler");
                bpmDefXmlHandler.saveNodeXml(defId, nodeId, jumpRuleList);
                resultMsg = "更新节点跳转规则成功";
            }
        } catch (Exception e) {
        }
    }


    /**
     * 节点规则脚本设置
     */
    @RequestMapping("eventScriptEdit")
    public ModelAndView eventScriptEdit(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String defId = RequestUtil.getString(request, "defId");
        String nodeId = RequestUtil.getString(request, "nodeId");
        BpmNodeDef bpmNodeDef = bpmDefinitionAccessor.getBpmNodeDef(defId, nodeId);
        Map<ScriptType, String> scriptMap = bpmNodeDef.getScripts();
        return getAutoView().addObject("bpmNodeDef", bpmNodeDef).addObject("defId", defId).addObject("nodeId", nodeId).addObject("eventScriptMap", scriptMap);
    }


    /**
     * 节点事件脚本保存
     */
    @RequestMapping("eventScriptSave")
    public void eventScriptSave(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String defId = RequestUtil.getString(request, "defId");
        String nodeId = RequestUtil.getString(request, "nodeId");
        String eventScriptArray = RequestUtil.getString(request, "eventScriptArray");
        try {

			
			/*EventScriptBpmDefXmlHandler eventScriptHandler = AppUtil.getBean(EventScriptBpmDefXmlHandler.class);
			JSONArray eventScript = JSONArray.fromObject(eventScriptArray);

			for (int i = 0; i < eventScript.size(); i++) {
				JSONObject objct = eventScript.getJSONObject(i);
				ScriptType scriptType = ScriptType.fromKey(objct.getString("scriptType"));
				EventScript es = new EventScript(scriptType, objct.getString("content"));

				eventScriptHandler.saveNodeXml(defId, nodeId, es);
			}*/
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    /**
     * 分支节点规则脚本设置
     */
    @RequestMapping("branchConditionEdit")
    public ModelAndView branchConditionEdit(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String defId = RequestUtil.getString(request, "defId");
        String nodeId = RequestUtil.getString(request, "nodeId");

        BpmNodeDef bpmNodeDef = bpmDefinitionAccessor.getBpmNodeDef(defId, nodeId);
        return getAutoView().addObject("bpmNodeDef", bpmNodeDef).addObject("defId", defId);
    }

    /**
     * 分支节点规则脚本保存
     */
    @RequestMapping("branchConditionSave")
    public void branchConditionSave(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String defId = RequestUtil.getString(request, "defId");
        String nodeId = RequestUtil.getString(request, "nodeId");
        String condition = RequestUtil.getString(request, "condition");
        try {

			/*DefaultBpmDefConditionService bpmDefHandler = AppUtil.getBean(DefaultBpmDefConditionService.class);
			JSONObject jsonObj = JSONObject.fromObject(condition);
			Map map = (Map) JSONObject.toBean(jsonObj, HashMap.class);
			bpmDefHandler.saveCondition(defId, nodeId, map);*/
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    /**
     * 自动任务管理页面
     */
    @RequestMapping("autoTaskManager")
    public ModelAndView autoTaskManager(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String defId = RequestUtil.getString(request, "defId");
        String nodeId = RequestUtil.getString(request, "nodeId");

        List<BpmPluginContext> autoTaskPluginList = (List<BpmPluginContext>) AppUtil.getBean("autoTaskPluginList");
        AutoTaskDef autoTaskDef = (AutoTaskDef) bpmDefinitionAccessor.getBpmNodeDef(defId, nodeId);
        BpmPluginContext bpmPluginContext = autoTaskDef.getAutoTaskBpmPluginContext();
        return getAutoView().addObject("autoTaskPluginList", autoTaskPluginList).addObject("defId", defId).addObject("nodeId", nodeId).addObject("bpmPluginContext", bpmPluginContext);
    }

    /**
     * 自动节点，获取插件数据
     */
    @RequestMapping("autoTaskPluginGet")
    public Object autoTaskPluginGet(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String defId = RequestUtil.getString(request, "defId");
        String nodeId = RequestUtil.getString(request, "nodeId");
        String pluginType = RequestUtil.getString(request, "pluginType");
        List<BpmVariableDef> bpmVariableList = getAllBpmVariableDef(defId, nodeId);

        ModelAndView mv = new ModelAndView("/flow/node/autoTask" + StringUtil.toFirst(pluginType, true) + "Edit");

        AutoTaskDef autoTaskDef = (AutoTaskDef) bpmDefinitionAccessor.getBpmNodeDef(defId, nodeId);

		/*AbstractBpmPluginContext bpmPluginContext = (AbstractBpmPluginContext) autoTaskDef.getAutoTaskBpmPluginContext();

		// 已经选择并保存该插件。
		if (bpmPluginContext != null && bpmPluginContext.getType().equals(pluginType)) {
			BpmPluginDef bpmPluginDef = bpmPluginContext.getBpmPluginDef();
			mv.addObject("bpmPluginDef", bpmPluginDef);
			String json = bpmPluginContext.getJson();
			json = JsonUtil.escapeSpecialChar(json);
			mv.addObject("bpmPluginDefJson", json);
		}*/

        return new MapBuilder<>().put("defId", defId).put("nodeId", nodeId).put("bpmPluginContext", /*bpmPluginContext*/null).put("pluginType", pluginType).put("bpmVariableList", bpmVariableList);
    }

    /**
     * 自动节点保存json 配置
     *
     * @param request
     * @param response
     * @throws Exception
     */
    @RequestMapping("autoTaskPluginSave")
    public void autoTaskPluginSave(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String resultMsg = null;
        String nodeId = RequestUtil.getString(request, "nodeId");
        String defId = RequestUtil.getString(request, "defId");
        String jsonStr = RequestUtil.getString(request, "jsonStr");
        try {
			/*if (StringUtil.isNotEmpty(nodeId)) {
				ServiceNodeBpmDefXmlHandler serviceNodeDefXmlHandler = AppUtil.getBean(ServiceNodeBpmDefXmlHandler.class);
				serviceNodeDefXmlHandler.saveNodeXml(defId, nodeId, jsonStr);
				resultMsg = "更新节点配置成功";
			}*/
        } catch (Exception e) {
            resultMsg = "更新节点配置失败";
            e.printStackTrace();
        }
    }


    /**
     * 会签规则特权配置
     */
    @RequestMapping("getSignConfig")
    @ResponseBody
    public Map<String, Object> bpmNodeSign(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String defId = RequestUtil.getString(request, "defId");
        String nodeId = RequestUtil.getString(request, "nodeId");

        SignNodeDef signNodeDef = (SignNodeDef) bpmDefinitionAccessor.getBpmNodeDef(defId, nodeId);
        List<PrivilegeItem> privilegeList = signNodeDef.getPrivilegeList();
        SignRule signRule = signNodeDef.getSignRule();

        Map<String, Object> map = new HashMap<String, Object>();
        map.put("privilegeList", getPrivilegeListJson(privilegeList));
        map.put("signRule", SignRule.toJson(signRule));
        return map;
    }


    /**
     * 将PrivilegeList 转化成json
     */
    private JSONObject getPrivilegeListJson(List<PrivilegeItem> privilegeList) {
        JSONObject jsonObject = JSONObject.newJSONObject();
        if (BeanUtils.isEmpty(privilegeList)) return jsonObject;

        for (PrivilegeItem privilege : privilegeList) {
			/*JsonConfig config=new JsonConfig();
			UserAssignRuleParser.handJsonConfig(config, privilege.getUserRuleList());
			JSON json= JSONSerializer.toJSON(privilege.getUserRuleList(),config);
			jsonObject.put(privilege.getPrivilegeMode().getKey(), json);*/
        }
        String json = jsonObject.toString().replaceAll("null,", "\"\",");
        return JSONObject.parseObject(json);
    }

    /**
     * 会签规则特权配置
     */
    @RequestMapping("signConfigSave")
    public void signConfigSave(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String resultMsg = null;
        String nodeId = RequestUtil.getString(request, "nodeId");
        String defId = RequestUtil.getString(request, "defId");
        String signRuleJson = RequestUtil.getString(request, "signRule");
        String privilegeListJson = RequestUtil.getString(request, "privilegeList");
        try {

            if (StringUtil.isNotEmpty(nodeId)) {
                List<PrivilegeItem> privilegeList = getPrivilegeList(privilegeListJson);
                SignRule signRule = getSignRule(signRuleJson);

				/*SignRulesBpmDefXmlHandler signRulesBpmDefXmlHandler = AppUtil.getBean(SignRulesBpmDefXmlHandler.class);
				signRulesBpmDefXmlHandler.saveNodeXml(defId, nodeId, signRule);
				resultMsg = "会签规则更新成功，会签权限人员配置更新失败!";

				PrivilegeBpmDefXmlHandler privilegeBpmDefXmlHandler = AppUtil.getBean(PrivilegeBpmDefXmlHandler.class);
				privilegeBpmDefXmlHandler.saveNodeXml(defId, nodeId, privilegeList);
				resultMsg = "会签节点配置成功";*/
            }
        } catch (Exception e) {
            resultMsg = resultMsg == null ? "会签规则配置失败" : resultMsg;
            e.printStackTrace();
        }
    }

    // /json to SingRule
    private SignRule getSignRule(String json) {
        JSONObject obj = JSONObject.parseObject(json);
        DecideType decideType = DecideType.fromKey(obj.get("decideType").toString());
        VoteType voteType = VoteType.fromKey(obj.get("voteType").toString());
        FollowMode followMode = FollowMode.fromKey(obj.get("followMode").toString());
        int voteAmount = obj.getIntValue("voteAmount");
        return new SignRule(decideType, voteType, followMode, voteAmount);
    }

    /**
     * PrivilegeList转化成 对象
     */
    private List<PrivilegeItem> getPrivilegeList(String json) {
        JSONObject privilegeListJson = JSONObject.parseObject(json);
        List<PrivilegeItem> privilegeList = new ArrayList<PrivilegeItem>();
        for (Object pKey : privilegeListJson.keySet()) {
            PrivilegeItem privilege = new PrivilegeItem();
            PrivilegeMode privilegeMode = PrivilegeMode.fromKey(pKey.toString());
            privilege.setPrivilegeMode(privilegeMode);

            JSONArray ruleArray = (JSONArray) privilegeListJson.get(pKey);
            if (ruleArray.size() == 0)
                continue;

            // /用户规则
            List<UserAssignRule> rules = new ArrayList<UserAssignRule>();
            for (int i = 0; i < ruleArray.size(); i++) {
                JSONObject ruleJsonObject = (JSONObject) ruleArray.get(i);
				/*UserAssignRule rule = UserAssignRuleParser.getUserAssignRule(ruleJsonObject);
				rules.add(rule);*/
            }
            privilege.setUserRuleList(rules);
            privilegeList.add(privilege);
        }

        return privilegeList;
    }

    /**
     * 预览人员条件
     *
     * @param request
     * @param response
     * @throws Exception
     */
    @RequestMapping("previewCondition")
    @ResponseBody
    public PageJson previewCondition(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String conditionArray = RequestUtil.getString(request, "conditionArray");
        String variables = RequestUtil.getString(request, "variables");
        Map<String, String> map = (Map<String, String>) JSONObject.parseObject(variables, Map.class);

        List<IUser> users = userQueryPluginHelper.queryUsersByConditions(conditionArray, map);
        return new PageJson(users);
    }

    /**
     * 获取流程节点的流程变量 bo变量，流程变量
     */
    @RequestMapping("flowVarDialog")
    public ModelAndView flowVarDialog(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String defId = RequestUtil.getString(request, "defId");
        String nodeId = RequestUtil.getString(request, "nodeId");
//		List<GroupType> dimensionList = userGroupService.getGroupTypes();
        return getAutoView().addObject("defId", defId).addObject("nodeId", nodeId).addObject("dimensionList", null);
    }

    /**
     * 该节点能用的所有变量
     */
    private List<BpmVariableDef> getAllBpmVariableDef(String defId, String nodeId) {
        List<BpmVariableDef> bpmVariableList = new ArrayList<BpmVariableDef>();
        // 全局变量
        BpmProcessDef<BpmProcessDefExt> bpmProcessDefExt = bpmDefinitionAccessor.getBpmProcessDef(defId);
		/*DefaultBpmProcessDefExt defExt = (DefaultBpmProcessDefExt) bpmProcessDefExt.getProcessDefExt();
		if (defExt.getVariableList() != null) {
			bpmVariableList.addAll(defExt.getVariableList());
		}*/

        List<BpmNodeDef> list = bpmProcessDefExt.getBpmnNodeDefs();
        for (BpmNodeDef node : list) {
            if (!node.getNodeId().equals(nodeId))
                continue;

            if (!node.getType().toString().equalsIgnoreCase("usertask"))
                continue;

            UserTaskNodeDef targetNodeDef = (UserTaskNodeDef) node;
            if (targetNodeDef.getVariableList() != null) {
                bpmVariableList.addAll(targetNodeDef.getVariableList());
            }

        }
        return bpmVariableList;
    }

    /**
     * 规则选择框
     */
    @RequestMapping("userAssignConditionDialog")
    public ModelAndView userAssignConditionDialog(HttpServletRequest request, HttpServletResponse response, String defId, String nodeId) throws Exception {
        return new ModelAndView("/flow/def/userAssignConditionDialog.jsp").addObject("defId", defId).addObject("nodeId", nodeId);
    }


    /**
     * 判断手机表单是否存在。
     *
     * @param defId
     * @param bpmDefSetting
     * @return
     */
    private boolean isMobileSet(String defId, BpmDefSetting bpmDefSetting) {
        BpmProcessDef<BpmProcessDefExt> bpmProcessDef = bpmDefinitionAccessor.getBpmProcessDef(defId);
		/*DefaultBpmProcessDefExt defExt = (DefaultBpmProcessDefExt) bpmProcessDef.getProcessDefExt();
		
		BpmNodeDef nodeDef= bpmDefinitionAccessor.getStartEvent(defId);
		
		List<BpmNodeDef> startNodes= bpmDefinitionAccessor.getStartNodes(defId);
		Map<String,IForm> nodeMap= bpmDefSetting.getFormMap(false);
		
		IForm startForm=nodeMap.get(nodeDef.getNodeId());
		boolean isSet=isFormEmpty(startForm);
		if(isSet)  return true;
		
		for(BpmNodeDef def:startNodes){
			IForm frm=nodeMap.get(def.getNodeId());
			isSet=isFormEmpty(frm);
			if(isSet) return true;
		}
		IForm globalForm=defExt.getGlobalMobileForm();
		isSet=isFormEmpty(globalForm);
		return isSet;*/
        return false;
    }

    private boolean isFormEmpty(IForm startForm) {
        if (startForm != null && StringUtil.isNotEmpty(startForm.getFormHtml())) {
            return true;
        }
        return false;
    }


    /**
     * 验证handler。 输入格式为 serviceId +"." + 方法名。
     *
     * @param request
     * @param response
     * @throws IOException
     */
    @RequestMapping("validHandler")
    public void validHandler(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String handler = RequestUtil.getString(request, "handler");
        int rtn = HandlerUtil.isHandlerValid(handler);
        String template = "{\"result\":\"%s\",\"msg\":\"%s\"}";
        String msg = "";
        switch (rtn) {
            case 0:
                msg = "输入有效";
                break;
            case -1:
                msg = "输入格式无效";
                break;
            case -2:
                msg = "没有service类";
                break;
            case -3:
                msg = "没有对应的方法";
                break;
            default:
                msg = "其他错误";
                break;
        }
        String str = String.format(template, rtn, msg);
        response.getWriter().print(str);
    }

    /**
     * 流程变量对话框的树 其中包含：bodef的字段，流程变量，流程常量（发起人,当前用户,...）
     *
     * @param request
     * @param response
     * @return
     * @throws Exception Object
     * @throws
     * @since 1.0.0
     */
    @RequestMapping("varTree")
    @ResponseBody
    public Object varTree(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String defId = RequestUtil.getString(request, "defId");
        boolean removeSub = RequestUtil.getBoolean(request, "removeSub", false);
        boolean removeMain = RequestUtil.getBoolean(request, "removeMain", false);
        String flowKey = RequestUtil.getString(request, "flowKey");

        if (StringUtil.isEmpty(defId) && StringUtil.isNotEmpty(flowKey)) {
            BpmDefinition definition = bpmDefinitionService.getBpmDefinitionByDefKey(flowKey, false);
            defId = definition.getDefId();
        }

        com.alibaba.fastjson.JSONArray treeJA = new com.alibaba.fastjson.JSONArray();

        if (StringUtil.isEmpty(defId)) return treeJA;

        // 获取流程定义
        BpmProcessDef<BpmProcessDefExt> procDef = bpmDefinitionAccessor.getBpmProcessDef(defId);


        // 获取表单BO树
        List<ProcBoDef> boDefs = procDef.getProcessDefExt().getBoDefList();
        com.alibaba.fastjson.JSONArray boList = new com.alibaba.fastjson.JSONArray();

        if (BeanUtils.isNotEmpty(boDefs)) {
            for (ProcBoDef boDef : boDefs) {
                BoDef def = bODefManager.getByAlias(boDef.getKey());
                /*JSONObject objec = bODefManager.getBoJson(def.getId());
                objec.put("name", objec.getString("path"));
// 去掉子表数据
                if (removeSub || removeMain) {
                    JSONArray children = objec.getJSONArray("children");
                    JSONArray temp = JSONArray.newJSONArray();
                    for (Object obj : children) {
                        JSONObject json = (JSONObject) obj;
                        if (json.get("children") == null && removeSub) {
                            temp.add(json);
                        }
                        if (json.get("children") != null && removeMain) {
                            temp.add(json);
                        }
                    }
                    objec.put("children", temp);
                }
                boList.add(objec);*/
            }

            JSONObject bos = JSONObject.parseObject("{id:\"0\",parentId:\"-1\",description:\"BO对象属性\",icon:\"fa fa-bold dark\"}");
            bos.put("children", boList);
            treeJA.add(bos);
        }

        // 获取流程变量
        boolean includeBpmConstants = RequestUtil.getBoolean(request, "includeBpmConstants", true);
        JSONObject flowVarJson = getFlowVarJson(procDef, includeBpmConstants);
        if (flowVarJson != null) {
            treeJA.add(flowVarJson);
        }

        return treeJA;
    }

    private JSONObject getFlowVarJson(BpmProcessDef<BpmProcessDefExt> procDef, boolean includeBpmConstants) {
        List<BpmVariableDef> variables = procDef.getProcessDefExt().getVariableList();
        JSONObject flowVariable = JSONObject.parseObject("{description:\"流程变量\",icon:\"fa fa-bold dark\",\"nodeType\":\"root\"}");

        JSONArray varList = JSONArray.newJSONArray();
        if (BeanUtils.isNotEmpty(variables)) {
            for (BpmVariableDef variable : variables) {
                String name = variable.getName();
                variable.setName(variable.getVarKey()); // @ 前端流程变量都是 取name，
                // 而名字为desc
                JSONObject obj = JSONObject.toJSON(variable);
                obj.put("nodeType", "var");
                obj.put("desc", name);
                varList.add(obj);
            }
        }
        // 如果表单变量需要包含流程常量
        if (includeBpmConstants) {
            JSONObject bmpnInstId = JSONObject.parseObject("{\"name\":\"" + BpmConstants.PROCESS_INST_ID + "\",\"description\":\"流程实例ID\",\"nodeType\":\"var\"}");
            JSONObject bussinessKey = JSONObject.parseObject("{\"name\":\"" + BpmConstants.BPM_FLOW_KEY + "\",\"description\":\"流程定义Key\",\"nodeType\":\"var\"}");
            JSONObject startUser = JSONObject.parseObject("{\"name\":\"" + BpmConstants.START_USER + "\",\"description\":\"发起人\",\"nodeType\":\"var\"}");

            varList.add(bmpnInstId);
            varList.add(bussinessKey);
            varList.add(startUser);
        }
        if (varList.isEmpty()) {
            return null;
        }
        flowVariable.put("children", varList);
        return flowVariable;
    }

    /**
     * 获取流程节点的列表 一些基本信息而已
     *
     * @param request
     * @param response
     * @return
     * @throws Exception Object
     * @throws
     * @since 1.0.0
     */
    @RequestMapping("getNodes")
    @ResponseBody
    public Object getNodes(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String defId = RequestUtil.getString(request, "defId", "");
        List<BpmNodeDef> nodeDefs = bpmDefinitionAccessor.getAllNodeDef(defId);

        JSONArray list = JSONArray.newJSONArray();
        for (BpmNodeDef node : nodeDefs) {
            JSONObject jo = JSONObject.newJSONObject();
            jo.put("name", node.getName());
            jo.put("nodeId", node.getNodeId());
            jo.put("type", node.getType().toString());
            list.add(jo);
        }
        return list;
    }

    /**
     * 流程定义页面
     *
     * @return json
     * @throws Exception
     */
    @RequestMapping("nodeDefSetting")
    public ModelAndView nodeDefSetting(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String defId = RequestUtil.getString(request, "defId");
        String topDefKey = RequestUtil.getString(request, "topDefKey", "");
		
		/*DefaultBpmDefinition bpmDefinition = null;
		BpmDefLayout bpmDefLayout = null;
		if (StringUtil.isNotEmpty(defId)) {
			bpmDefinition = bpmDefinitionManager.getById(defId);
			// 流程图layout
			bpmDefLayout = diagramService.getLayoutByDefId(defId);
		}
		//if(StringUtil.isEmpty(topDefKey)) topDefKey=bpmDefinition.getDefKey();
		List<JmsHandler<JmsVo>> messageTypelist = MessageUtil.getHanlerList();*/
	/*	return getAutoView().addObject("bpmDefinition", bpmDefinition)
				.addObject("bpmDefLayout", bpmDefLayout)
				.addObject("messageTypelist", messageTypelist)
				.addObject("topDefKey", topDefKey);*/
        return null;
    }

    /**
     * 流程定义设置json数据
     *
     * @return json
     * @throws Exception
     */
    @RequestMapping("getDefSetting")
    @ResponseBody
    public JSONObject getDefSetting(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String defId = RequestUtil.getString(request, "defId");
        String topDefKey = RequestUtil.getString(request, "topDefKey", "");
        JSONObject returnData = JSONObject.newJSONObject();
		
		/*BpmProcessDef<BpmProcessDefExt> bpmProcessDefExt = bpmDefinitionAccessor.getBpmProcessDef(defId);
		List<BpmNodeDef> nodeDefList = bpmProcessDefExt.getBpmnNodeDefs();
		DefaultBpmProcessDefExt defExt = (DefaultBpmProcessDefExt) bpmProcessDefExt.getProcessDefExt();
		
		BpmDefSetting bpmDefSetting = new BpmDefSetting();
		bpmDefSetting.setParentDefKey(topDefKey);
		//全局表单
		bpmDefSetting.setGlobalForm(StringUtil.isEmpty(topDefKey)?defExt.getGlobalForm():defExt.getGlobalFormByDefKey(topDefKey, false));
		bpmDefSetting.setGlobalMobileForm(StringUtil.isEmpty(topDefKey)? defExt.getGlobalMobileForm():defExt.getGlobalFormByDefKey(topDefKey, true));
		bpmDefSetting.setInstForm(defExt.getInstForm());
		bpmDefSetting.setInstMobileForm(defExt.getInstMobileForm());*/

        //节点设置，节点表单，节点信息，节点脚本
        JSONArray nodes = JSONArray.newJSONArray();
        List<IForm> formList = new ArrayList<IForm>();
        List<NodeProperties> properties = new ArrayList<NodeProperties>();
        Map<String, List<Button>> btnMap = new HashMap<String, List<Button>>();
        Map<String, JSONObject> nodeScriptMap = new HashMap<String, JSONObject>();
		
		/*handNodeDefSetting(topDefKey,nodeDefList,properties,formList,nodes,btnMap,nodeScriptMap);
		bpmDefSetting.setNodeProperties(properties);
		bpmDefSetting.setNodeForms(formList);
		
		String jsonObject = com.alibaba.fastjson.JSON.toJSON(bpmDefSetting).toString();*/
        String userJson = getNodesUserJson(request, response).toString();
		
		/*DefaultBpmDefinition def= (DefaultBpmDefinition) bpmDefinitionService.getBpmDefinitionByDefId(defId);
		int reversion = def.getRev();
		
		returnData.put("bpmDefinitionReversion",reversion);
*/
//		returnData.put("bpmDefSetting",JSONObject.parseObject(jsonObject).toString());
        returnData.put("nodes", nodes);
        returnData.put("nodeUserMap", JSONObject.parseObject(userJson));
        returnData.put("nodeBtnMap", btnMap);
        returnData.put("nodeScriptMap", nodeScriptMap);

        return returnData;
    }

    //整理用户节点  节点信息，节点属性，节点表单，手机表单,节点按钮
    private void handNodeDefSetting(String parentDefKey, List<BpmNodeDef> nodeDefList,
                                    List<NodeProperties> properties, List<IForm> formList, JSONArray nodes,
                                    Map<String, List<Button>> btnMap, Map<String, JSONObject> nodeScriptMap) {
        JSONObject node = JSONObject.newJSONObject();
        for (BpmNodeDef nodeDef : nodeDefList) {
            String nodeId = nodeDef.getNodeId();
            NodeType type = nodeDef.getType();
            if (NodeType.START.equals(type) || NodeType.USERTASK.equals(type) || NodeType.SIGNTASK.equals(type)) {
                //节点信息
                node.put("name", nodeDef.getName());
                node.put("nodeId", nodeId);
                node.put("type", nodeDef.getType().toString());
                nodes.add(node);

                //节点表单，节点按钮，节点手机表单
                IForm form = null;
                IForm mobileForm = null;
                NodeProperties propertie = null;
                //本地节点。
                if (StringUtil.isEmpty(parentDefKey) || BpmConstants.LOCAL.equals(parentDefKey)) {
                    propertie = nodeDef.getLocalProperties();
                    form = nodeDef.getForm();
                    mobileForm = nodeDef.getMobileForm();
                } else {
                    propertie = nodeDef.getPropertiesByParentDefKey(parentDefKey);
                    form = nodeDef.getSubForm(parentDefKey, FormType.Type.PC);
                    mobileForm = nodeDef.getSubForm(parentDefKey, FormType.Type.MOBILE);
                }
                //开始节点不加属性配置
                if (!NodeType.START.equals(type)) {
                    if (propertie != null) {
                        propertie.setNodeId(nodeId);
                        properties.add(propertie);
                    }
                }

                //设置form默认值
				/*if(form== null) {
					form = new Form();
					form.setType(FormCategory.INNER);
				}
				if(mobileForm== null){
					mobileForm = new Form();
					mobileForm.setFormType(FormType.MOBILE.value());
				}
				
				form.setNodeId(nodeId);
				mobileForm.setNodeId(nodeId);
				formList.add(mobileForm);
				formList.add(form);
*/
                List<Button> buttons = nodeDef.getButtons();
                btnMap.put(nodeDef.getNodeId(), buttons);
            } else if (NodeType.SUBPROCESS.equals(type)) {
                SubProcessNodeDef subProcessNodeDef = (SubProcessNodeDef) nodeDef;
                BpmProcessDef<? extends BpmProcessDefExt> processDef = subProcessNodeDef.getChildBpmProcessDef();
                List<BpmNodeDef> bpmNodeDefs = processDef.getBpmnNodeDefs();
                handNodeDefSetting(parentDefKey, bpmNodeDefs, properties, formList, nodes, btnMap, nodeScriptMap);
            }
            //节点脚本
            Map<ScriptType, String> scriptMap = nodeDef.getScripts();
            if (!scriptMap.isEmpty()) {
                nodeScriptMap.put(nodeId, JSONObject.parseObject(com.alibaba.fastjson.JSON.toJSON(scriptMap).toString()));
            }

        }
    }

    //获取所有节点人员的JSON
    private Object getNodesUserJson(HttpServletRequest request, HttpServletResponse response) throws Exception {

        String defId = RequestUtil.getString(request, "defId", "");
        String parentFlowKey = RequestUtil.getString(request, "topDefKey", BpmConstants.LOCAL);

        List<BpmNodeDef> nodeDefList = bpmDefinitionAccessor.getAllNodeDef(defId);
        com.alibaba.fastjson.JSONObject jobject = new com.alibaba.fastjson.JSONObject();
        List<BpmNodeDef> userNodes = new ArrayList<BpmNodeDef>();
        for (BpmNodeDef nodeDef : nodeDefList) {
            if (nodeDef.getType() == NodeType.USERTASK || nodeDef.getType() == NodeType.SIGNTASK)
                userNodes.add(nodeDef);
        }

        for (int i = 0; i < userNodes.size(); i++) {
            BpmNodeDef node = userNodes.get(i);
			/*UserAssignPluginContext userPluginContext = (UserAssignPluginContext) node.getPluginContext(UserAssignPluginContext.class);
			if (userPluginContext == null) {
				jobject.put(node.getNodeId(), new JSONArray());
			} 
			else {
				String nodeConditionJson = userPluginContext.getJsonByParentFlowKey(parentFlowKey);
				Object nodeConditionJsonAry = com.alibaba.fastjson.JSONArray.parse(nodeConditionJson);
				jobject.put(node.getNodeId(), nodeConditionJsonAry);
			}*/
        }
        return jobject;
    }

    /**
     * 保存流程配置
     *
     * @param request
     * @param reponse
     * @throws Exception
     */
    @RequestMapping("saveDefConf")
    public void saveDefConf(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String defId = RequestUtil.getString(request, "defId");
        String topDefKey = RequestUtil.getString(request, "topDefKey");
        String defSettingJson = RequestUtil.getString(request, "bpmDefSetting");
        String userJson = RequestUtil.getString(request, "nodeUserMap");
        int bpmDefinitionReversion = RequestUtil.getInt(request, "bpmDefinitionReversion");

        //保存表单
//		BpmDefSettingBpmDefXmlHandler bpmDefSettingBpmDefXmlHandler = AppUtil.getBean(BpmDefSettingBpmDefXmlHandler.class);
        try {
            BpmDefSetting bpmDefSetting = com.alibaba.fastjson.JSON.parseObject(defSettingJson, BpmDefSetting.class);
			
			/*DefaultBpmDefinition bpmDefinition = (DefaultBpmDefinition) bpmDefinitionService.getBpmDefinitionByDefId(defId);
			if(bpmDefinitionReversion != bpmDefinition.getRev()){
				throw new RuntimeException("当前流程定义版本太旧！服务器版本"+bpmDefinition.getRev()+" 当前版本："+bpmDefinitionReversion);
			}*/

            //设置是否支持手机表单。
            int supportMobile = isMobileSet(defId, bpmDefSetting) ? 1 : 0;

            //更新defnition check Rev
			/*bpmDefinition.setSupportMobile(supportMobile);
			bpmDefinitionManager.update(bpmDefinition);
			*/
//			bpmDefSettingBpmDefXmlHandler.saveNodeXml(defId, null, bpmDefSetting);
        } catch (Exception e) {
            e.printStackTrace();
            return;
        }
        String theNode = "";
        try {
            //保存人员
            JSONObject jsonObject = JSONObject.parseObject(userJson);
            Set<String> nodeIds = jsonObject.keySet();
            for (String nodeId : nodeIds) {
                theNode = nodeId;
				/*UserDefBpmDefXmlHandler userDefBpmDefXmlHandler = (UserDefBpmDefXmlHandler) AppUtil.getBean(UserDefBpmDefXmlHandler.class);
				userDefBpmDefXmlHandler.saveNodeXml(defId, nodeId, jsonObject.get(nodeId).toString(), topDefKey);*/
            }
        } catch (Exception e) {
            e.printStackTrace();
        }


    }


    @RequestMapping("getNodeOutcomes")
    @ResponseBody
    public Object getNodeOutcomes(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String defId = RequestUtil.getString(request, "defId");
        String nodeId = RequestUtil.getString(request, "nodeId");
        BpmNodeDef nodeDef = bpmDefinitionAccessor.getBpmNodeDef(defId, nodeId);
        if (nodeDef == null) return null;
        JSONObject data = JSONObject.newJSONObject();
        JSONArray outComes = JSONArray.newJSONArray();
        for (BpmNodeDef n : nodeDef.getOutcomeNodes()) {
            JSONObject nodeJson = JSONObject.newJSONObject();
            nodeJson.put("nodeName", n.getName());
            nodeJson.put("nodeId", n.getNodeId());
            outComes.add(nodeJson);
        }
        data.put("scriptMap", nodeDef.getConditions());
        data.put("outComes", outComes);
        return data;
    }

    /**
     * 自动任务信息明细
     */
    @RequestMapping("getNodeAutoTask")
    @ResponseBody
    public Object getNodeAutoTask(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String defId = RequestUtil.getString(request, "defId");
        String nodeId = RequestUtil.getString(request, "nodeId");

        AutoTaskDef autoTaskDef = (AutoTaskDef) bpmDefinitionAccessor.getBpmNodeDef(defId, nodeId);
		/*AbstractBpmPluginContext bpmPluginContext = (AbstractBpmPluginContext)autoTaskDef.getAutoTaskBpmPluginContext();
		if(bpmPluginContext == null)return null;
		
		JSONObject object = JSONObject.fromObject( bpmPluginContext.getJson());
		object.put("title", bpmPluginContext.getTitle());*/
        return null;
    }
}
