package cn.shper.tkui.bottombar

import android.content.Context
import android.content.res.TypedArray
import android.util.AttributeSet
import android.view.View
import android.widget.TextView
import androidx.annotation.ColorInt
import androidx.constraintlayout.widget.ConstraintLayout
import cn.shper.tkui.R
import cn.shper.tkui.TKIconTextView
import kotlinx.android.synthetic.main.tkui_item_bottombar.view.*

/**
 * Author: Shper
 * Email: me@shper.cn
 * Version: V0.1 2021/11/15
 */
class TKBottomBarItem @JvmOverloads constructor(context: Context,
                                                attrs: AttributeSet? = null,
                                                defStyleAttr: Int = 0) :
  ConstraintLayout(context, attrs, defStyleAttr) {

  var itemIcon: TKIconTextView? = null
  var iconNormalColorInt: Int? = null
  var iconSelectedColorInt: Int? = null

  var itemText: TextView? = null
  var textNormalColorInt: Int? = null
  var textSelectedColorInt: Int? = null

  var itemTips: TextView? = null
  var itemRedPoint: TextView? = null

  init {
    View.inflate(context, R.layout.tkui_item_bottombar, this)
    val typedArray = context.obtainStyledAttributes(attrs, R.styleable.TKBottomBarItem)
    setupUI(typedArray)
    setupBackground(typedArray)

    typedArray.recycle()
  }

  private fun setupUI(typedArray: TypedArray) {
    itemIcon = tkui_item_icon
    itemText = tkui_item_text
    itemTips = tkui_item_tips
    itemRedPoint = tkui_item_red_point

    // Icon
    if (typedArray.hasValue(R.styleable.TKBottomBarItem_iconStr)) {
      itemIcon?.text = typedArray.getString(R.styleable.TKBottomBarItem_iconStr)
    }
    iconNormalColorInt = typedArray.getColor(R.styleable.TKBottomBarItem_iconNormalColor,
        context.resources.getColor(R.color.tkui_black))
    itemIcon?.setTextColor(iconNormalColorInt!!)

    iconSelectedColorInt = typedArray.getColor(R.styleable.TKBottomBarItem_iconSelectColor,
        context.resources.getColor(R.color.tkui_blue))

    // Text
    if (typedArray.hasValue(R.styleable.TKBottomBarItem_text)) {
      itemText?.text = typedArray.getString(R.styleable.TKBottomBarItem_text)
    }
    textNormalColorInt = typedArray.getColor(R.styleable.TKBottomBarItem_textNormalColor,
        context.resources.getColor(R.color.tkui_black))
    itemText?.setTextColor(textNormalColorInt!!)

    textSelectedColorInt = typedArray.getColor(R.styleable.TKBottomBarItem_textSelectColor,
        context.resources.getColor(R.color.tkui_blue))
  }

  private fun setupBackground(typedArray: TypedArray) {
    val backgroundColor = typedArray.getColor(R.styleable.TKBottomBarItem_android_background,
        context.resources.getColor(R.color.tkui_white))
    this.setBackgroundColor(backgroundColor)
  }

  fun setIcon(iconStr: String) {
    itemIcon?.text = iconStr
  }

  fun setIconColor(@ColorInt color: Int) {
    itemIcon?.setTextColor(color)
  }

  fun setText(text: String) {
    itemText?.text = text
  }

  fun setTextColor(@ColorInt color: Int) {
    itemText?.setTextColor(color)
  }

  fun setTipsContent(content: String) {
    itemTips?.text = content
  }

  fun showTips() {
    itemTips?.visibility = View.VISIBLE
  }

  fun hideTips() {
    itemTips?.visibility = View.GONE
  }

  fun showRedPoint() {
    itemRedPoint?.visibility = View.VISIBLE
  }

  fun hideRedPoint() {
    itemRedPoint?.visibility = View.GONE
  }

  override fun setSelected(selected: Boolean) {
    super.setSelected(selected)
    if (selected) {
      iconSelectedColorInt?.let { itemIcon?.setTextColor(it) }
      textSelectedColorInt?.let { itemText?.setTextColor(it) }
    } else {
      iconNormalColorInt?.let { itemIcon?.setTextColor(it) }
      textNormalColorInt?.let { itemText?.setTextColor(it) }
    }
  }

}