/*
 * Decompiled with CFR 0.152.
 */
package cn.slipi.admin.biz.monitor;

import cn.slipi.admin.biz.monitor.vo.app.AddForm;
import cn.slipi.admin.biz.monitor.vo.app.AppVo;
import cn.slipi.admin.biz.monitor.vo.app.BindForm;
import cn.slipi.admin.biz.monitor.vo.app.BindInfoVo;
import cn.slipi.admin.biz.monitor.vo.app.BindUserVo;
import cn.slipi.admin.biz.monitor.vo.app.ServerVo;
import cn.slipi.admin.common.enums.ResponseCode;
import cn.slipi.admin.common.exception.BizException;
import cn.slipi.admin.common.page.PageParam;
import cn.slipi.admin.common.util.dozer.impl.ConvertBean;
import cn.slipi.admin.service.client.entity.ClientRegistry;
import cn.slipi.admin.service.client.service.ClientRegistryService;
import cn.slipi.admin.service.monitor.entity.App;
import cn.slipi.admin.service.monitor.entity.AppNotify;
import cn.slipi.admin.service.monitor.entity.Server;
import cn.slipi.admin.service.monitor.service.AppNotifyService;
import cn.slipi.admin.service.monitor.service.AppService;
import cn.slipi.admin.service.monitor.service.ServerService;
import cn.slipi.admin.service.system.entity.User;
import cn.slipi.admin.service.system.service.UserService;
import cn.slipi.monitor.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AppBiz {
    @Autowired
    private ConvertBean convertBean;
    @Autowired
    private AppService appService;
    @Autowired
    private UserService userService;
    @Autowired
    private ServerService serverService;
    @Autowired
    private AppNotifyService appNotifyService;
    @Autowired
    private ClientRegistryService clientRegistryService;

    public List<AppVo> page(PageParam<App> pageParam) {
        pageParam.setDefaultOrder(null, new String[]{"create_time"});
        List appList = this.appService.listPage(pageParam);
        ArrayList<AppVo> appVos = new ArrayList<AppVo>();
        List appNameList = appList.stream().map(App::getAppName).filter(appName -> !StrUtil.isBlank((CharSequence)appName)).collect(Collectors.toList());
        List<Object> lanList = new ArrayList();
        List<Object> hostList = new ArrayList();
        Map<Object, Object> clientMap = new HashMap();
        if (appNameList.size() > 0) {
            QueryWrapper clientRegistryQueryWrapper = new QueryWrapper();
            clientRegistryQueryWrapper.in((Object)"app_name", appNameList);
            List clientRegistryList = this.clientRegistryService.list((Wrapper)clientRegistryQueryWrapper);
            clientMap = clientRegistryList.stream().collect(Collectors.groupingBy(ClientRegistry::getAppName));
            hostList = clientRegistryList.stream().map(ClientRegistry::getHost).filter(host -> !StrUtil.isBlank((CharSequence)host)).collect(Collectors.toList());
            lanList = clientRegistryList.stream().map(ClientRegistry::getLan).filter(lan -> !StrUtil.isBlank((CharSequence)lan)).collect(Collectors.toList());
        }
        Map<Object, Object> lanServer = new HashMap();
        if (hostList.size() > 0 || lanList.size() > 0) {
            QueryWrapper serverQueryWrapper = new QueryWrapper();
            if (hostList.size() > 0) {
                serverQueryWrapper.in((Object)"host", hostList);
                if (lanList.size() > 0) {
                    ((QueryWrapper)serverQueryWrapper.or()).in((Object)"lan", lanList);
                }
            } else {
                serverQueryWrapper.in((Object)"lan", lanList);
            }
            List serverList = this.serverService.getBaseMapper().selectList((Wrapper)serverQueryWrapper);
            lanServer = serverList.stream().collect(Collectors.toMap(Server::getLan, server -> server));
        }
        HashMap finalLanServer = lanServer;
        HashMap finalClientMap = clientMap;
        appList.forEach(app -> {
            AppVo appVo = (AppVo)this.convertBean.convert(app, AppVo.class);
            List clientList = finalClientMap.getOrDefault(app.getAppName(), new ArrayList());
            appVo.setLanList(clientList.stream().map(ClientRegistry::getLan).collect(Collectors.toList()));
            appVo.setHostList(clientList.stream().map(ClientRegistry::getHost).collect(Collectors.toList()));
            List<String> appLanList = clientList.stream().map(ClientRegistry::getLan).collect(Collectors.toList());
            ArrayList serverVoList = new ArrayList();
            appLanList.forEach(appLan -> {
                Server server = finalLanServer.getOrDefault(appLan, null);
                if (server != null) {
                    ServerVo serverVo = new ServerVo();
                    serverVo.setLan(server.getLan());
                    serverVo.setHost(server.getHost());
                    serverVo.setServerName(server.getName());
                    serverVoList.add(serverVo);
                }
            });
            appVo.setServers(serverVoList);
            appVos.add(appVo);
        });
        return appVos;
    }

    public String updateNotify(Integer id, Integer isNotify, User loginUser) {
        List appNotifyList;
        List userIds;
        App app = (App)this.appService.getById((Serializable)id);
        if (app == null) {
            throw new BizException(ResponseCode.BIZ_RECORD_NOT_FOUND);
        }
        app.setIsNotify(isNotify);
        app.setLastUserId(loginUser.getUserId());
        if (this.appService.updateById((Object)app) && (userIds = (appNotifyList = this.appNotifyService.listByAppId(id)).stream().map(AppNotify::getUserId).collect(Collectors.toList())).size() > 0) {
            List userList = this.userService.listByIds(userIds);
            List nameList = userList.stream().map(User::getUsername).collect(Collectors.toList());
            return String.join((CharSequence)",", nameList);
        }
        return "";
    }

    public boolean add(AddForm form) {
        App app = (App)this.convertBean.convert((Object)form, App.class);
        return this.appService.saveApp(app);
    }

    public boolean update(App app) {
        return this.appService.updateApp(app);
    }

    public boolean deleteBatch(User user, List<Integer> ids) {
        this.appNotifyService.removeByAppIds(ids);
        return this.appService.removeApp(user.getUserId(), ids);
    }

    public boolean delete(User user, Integer id) {
        ArrayList<Integer> ids = new ArrayList<Integer>();
        ids.add(id);
        this.appNotifyService.removeByAppIds(ids);
        return this.appService.removeApp(user.getUserId(), ids);
    }

    public BindInfoVo bindList(Integer id) {
        BindInfoVo bindInfoVo = new BindInfoVo();
        ArrayList bindUserVoList = new ArrayList();
        List userList = this.userService.listAll();
        List notifyRelations = this.appNotifyService.listByAppId(id);
        Map<Integer, AppNotify> notifyRelationsMap = notifyRelations.stream().collect(Collectors.toMap(AppNotify::getUserId, relation -> relation));
        userList.forEach(user -> {
            BindUserVo bindUserVo = new BindUserVo();
            bindUserVo.setChecked(Boolean.valueOf(notifyRelationsMap.get(user.getUserId()) != null));
            bindUserVo.setUserId(user.getUserId());
            bindUserVo.setUserName(user.getUsername());
            bindUserVoList.add(bindUserVo);
        });
        bindInfoVo.setUsers(bindUserVoList);
        return bindInfoVo;
    }

    public void bind(BindForm form) {
        form.getBindUser().forEach(bindUserInfo -> {
            if (bindUserInfo.getChange().booleanValue()) {
                if (this.appNotifyService.getRelationByAppIdAndUserId(form.getAppId(), bindUserInfo.getUserId()) == null) {
                    AppNotify appNotify = new AppNotify();
                    appNotify.setAppId(form.getAppId());
                    appNotify.setUserId(bindUserInfo.getUserId());
                    this.appNotifyService.insertRelation(appNotify);
                }
            } else {
                AppNotify appNotify = this.appNotifyService.getRelationByAppIdAndUserId(form.getAppId(), bindUserInfo.getUserId());
                this.appNotifyService.removeById((Serializable)appNotify);
            }
        });
    }
}

