/*
 * Decompiled with CFR 0.152.
 */
package cn.slipi.admin.biz.monitor;

import cn.slipi.admin.biz.monitor.vo.client.ClientRegistryVo;
import cn.slipi.admin.common.enums.ResponseCode;
import cn.slipi.admin.common.exception.BizException;
import cn.slipi.admin.common.page.PageParam;
import cn.slipi.admin.common.util.JsonUtil;
import cn.slipi.admin.common.util.cache.JedisClusterUtil;
import cn.slipi.admin.common.util.dozer.impl.ConvertBean;
import cn.slipi.admin.core.thread.model.SystemInfo;
import cn.slipi.admin.service.client.entity.ClientRegistry;
import cn.slipi.admin.service.client.service.ClientRegistryService;
import cn.slipi.monitor.core.util.StrUtil;
import java.io.Serializable;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ClientBiz {
    private static final Logger logger = LoggerFactory.getLogger(ClientBiz.class);
    @Autowired
    private ConvertBean convertBean;
    @Autowired
    private JedisClusterUtil jedisClusterUtil;
    @Autowired
    private ClientRegistryService clientRegistryService;

    public List<ClientRegistryVo> page(PageParam<ClientRegistry> pageParam) {
        pageParam.setDefaultOrder(null, new String[]{"create_time"});
        List clientRegistryList = this.clientRegistryService.listPage(pageParam);
        return this.convertBean.convert(clientRegistryList, ClientRegistryVo.class);
    }

    public ClientRegistryVo detail(Integer id) {
        ClientRegistry client = (ClientRegistry)this.clientRegistryService.getById((Serializable)id);
        if (client == null) {
            throw new BizException(ResponseCode.BIZ_RECORD_NOT_FOUND);
        }
        ClientRegistryVo clientRegistryVo = (ClientRegistryVo)this.convertBean.convert((Object)client, ClientRegistryVo.class);
        clientRegistryVo.setSystemInfo(this.getSystemInfo(client.getHost(), client.getLan()));
        return clientRegistryVo;
    }

    private SystemInfo getSystemInfo(String host, String lan) {
        String systemInfoStr = "";
        if (!StrUtil.isBlank((CharSequence)lan)) {
            String lanKey = String.format("%s:%s", "monitor:client:lan", lan);
            logger.info("GET lan = {}", (Object)lanKey);
            systemInfoStr = this.jedisClusterUtil.get(lanKey);
        }
        if (StrUtil.isBlank((CharSequence)systemInfoStr)) {
            if (!StrUtil.isBlank((CharSequence)host)) {
                String hostKey = String.format("%s:%s", "monitor:client:host", host);
                logger.info("GET host = {}", (Object)hostKey);
                systemInfoStr = this.jedisClusterUtil.get(hostKey);
            }
        } else {
            return (SystemInfo)JsonUtil.json2Object((String)systemInfoStr, SystemInfo.class);
        }
        if (StrUtil.isBlank((CharSequence)systemInfoStr)) {
            return null;
        }
        return (SystemInfo)JsonUtil.json2Object((String)systemInfoStr, SystemInfo.class);
    }
}

