/*
 * Decompiled with CFR 0.152.
 */
package cn.slipi.admin.biz.monitor;

import cn.slipi.admin.biz.monitor.vo.server.AddForm;
import cn.slipi.admin.biz.monitor.vo.server.ServerVo;
import cn.slipi.admin.common.page.PageParam;
import cn.slipi.admin.common.util.JsonUtil;
import cn.slipi.admin.common.util.cache.JedisClusterUtil;
import cn.slipi.admin.common.util.dozer.impl.ConvertBean;
import cn.slipi.admin.core.thread.model.SystemInfo;
import cn.slipi.admin.service.monitor.entity.Server;
import cn.slipi.admin.service.monitor.service.ServerService;
import cn.slipi.admin.service.system.entity.User;
import cn.slipi.monitor.core.util.StrUtil;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ServerBiz {
    private static final Logger logger = LoggerFactory.getLogger(ServerBiz.class);
    @Autowired
    private ConvertBean convertBean;
    @Autowired
    private ServerService serverService;
    @Autowired
    private JedisClusterUtil jedisClusterUtil;

    public List<ServerVo> page(PageParam<Server> pageParam) {
        pageParam.setDefaultOrder(null, new String[]{"create_time"});
        List serverList = this.serverService.listPage(pageParam);
        ArrayList<ServerVo> serverVoList = new ArrayList<ServerVo>();
        serverList.forEach(server -> {
            ServerVo serverVo = (ServerVo)this.convertBean.convert(server, ServerVo.class);
            serverVo.setListen(Integer.valueOf(this.getListen(server.getHost(), server.getLan())));
            serverVo.setSystemInfo(this.getSystemInfo(server.getHost(), server.getLan()));
            serverVoList.add(serverVo);
        });
        return serverVoList;
    }

    public boolean add(AddForm form) {
        Server server = (Server)this.convertBean.convert((Object)form, Server.class);
        return this.serverService.saveServer(server);
    }

    public boolean update(Server server) {
        return this.serverService.updateServer(server);
    }

    public boolean deleteBatch(User user, List<Integer> ids) {
        return this.serverService.removeServer(user.getUserId(), ids);
    }

    public boolean delete(User user, Integer id) {
        ArrayList<Integer> ids = new ArrayList<Integer>();
        ids.add(id);
        return this.serverService.removeServer(user.getUserId(), ids);
    }

    private int getListen(String host, String lan) {
        String listenStr = "0";
        if (!StrUtil.isBlank((CharSequence)lan)) {
            String lanKey = String.format("%s:%s", "monitor:client:server:listen:lan", lan);
            listenStr = this.jedisClusterUtil.get(lanKey);
            logger.info("GET listen lan = {},{}", (Object)lanKey, (Object)listenStr);
        }
        if (StrUtil.isBlank((CharSequence)listenStr) && !StrUtil.isBlank((CharSequence)host)) {
            String hostKey = String.format("%s:%s", "monitor:client:server:listen:host", host);
            listenStr = this.jedisClusterUtil.get(hostKey);
            logger.info("GET listen host = {},{}", (Object)hostKey, (Object)listenStr);
        }
        return StrUtil.isBlank((CharSequence)listenStr) ? 0 : Integer.parseInt(listenStr);
    }

    private SystemInfo getSystemInfo(String host, String lan) {
        String systemInfoStr = "";
        if (!StrUtil.isBlank((CharSequence)lan)) {
            String lanKey = String.format("%s:%s", "monitor:client:lan", lan);
            logger.info("GET systemInfo lan = {}", (Object)lanKey);
            systemInfoStr = this.jedisClusterUtil.get(lanKey);
            logger.info("GET lan systemInfoStr = {}", (Object)systemInfoStr);
        }
        if (StrUtil.isBlank((CharSequence)systemInfoStr)) {
            if (!StrUtil.isBlank((CharSequence)host)) {
                String hostKey = String.format("%s:%s", "monitor:client:host", host);
                logger.info("GET systemInfo host = {}", (Object)hostKey);
                systemInfoStr = this.jedisClusterUtil.get(hostKey);
                logger.info("GET host systemInfoStr = {}", (Object)systemInfoStr);
            }
        } else {
            return (SystemInfo)JsonUtil.json2Object((String)systemInfoStr, SystemInfo.class);
        }
        if (StrUtil.isBlank((CharSequence)systemInfoStr)) {
            return null;
        }
        return (SystemInfo)JsonUtil.json2Object((String)systemInfoStr, SystemInfo.class);
    }
}

