/*
 * Decompiled with CFR 0.152.
 */
package cn.slipi.admin.biz.system;

import cn.slipi.admin.common.enums.ResponseCode;
import cn.slipi.admin.common.exception.BizException;
import cn.slipi.admin.common.page.PageParam;
import cn.slipi.admin.common.util.CoreUtil;
import cn.slipi.admin.service.system.entity.Dictionary;
import cn.slipi.admin.service.system.service.DictionaryService;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DictionaryBiz {
    @Autowired
    private DictionaryService dictionaryService;

    public List<Dictionary> page(PageParam<Dictionary> pageParam) {
        return ((PageParam)this.dictionaryService.page(pageParam, (Wrapper)pageParam.getWrapper(new String[0]))).getRecords();
    }

    public List<Dictionary> list(PageParam<Dictionary> pageParam) {
        return this.dictionaryService.list((Wrapper)pageParam.getOrderWrapper());
    }

    public Dictionary get(Integer id) {
        return (Dictionary)this.dictionaryService.getById((Serializable)id);
    }

    public boolean add(Dictionary dictionary) {
        if (this.dictionaryService.count((Wrapper)new QueryWrapper().eq((Object)"dict_code", (Object)dictionary.getDictCode())) > 0) {
            throw new BizException(ResponseCode.BIZ_DICT_ITEM_EXISTS);
        }
        if (this.dictionaryService.count((Wrapper)new QueryWrapper().eq((Object)"dict_name", (Object)dictionary.getDictName())) > 0) {
            throw new BizException(ResponseCode.BIZ_DICT_FLAG_EXISTS);
        }
        return this.dictionaryService.save((Object)dictionary);
    }

    public boolean update(Dictionary dictionary) {
        if (this.dictionaryService.count((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"dict_code", (Object)dictionary.getDictCode())).ne((Object)"dict_id", (Object)dictionary.getDictId())) > 0) {
            throw new BizException(ResponseCode.BIZ_DICT_FLAG_EXISTS);
        }
        if (this.dictionaryService.count((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"dict_name", (Object)dictionary.getDictName())).ne((Object)"dict_id", (Object)dictionary.getDictId())) > 0) {
            throw new BizException(ResponseCode.BIZ_DICT_ITEM_EXISTS);
        }
        return this.dictionaryService.updateById((Object)dictionary);
    }

    public boolean remove(Integer id) {
        return this.dictionaryService.removeById((Serializable)id);
    }

    public boolean saveBatch(List<Dictionary> list) {
        StringBuilder sb = new StringBuilder();
        sb.append(CoreUtil.listCheckBlank(list, (String)"dictCode", (String)"\u5b57\u5178\u6807\u8bc6"));
        sb.append(CoreUtil.listCheckBlank(list, (String)"dictName", (String)"\u5b57\u5178\u540d\u79f0"));
        sb.append(CoreUtil.listCheckRepeat(list, (String)"dictCode", (String)"\u5b57\u5178\u6807\u8bc6"));
        sb.append(CoreUtil.listCheckRepeat(list, (String)"dictName", (String)"\u5b57\u5178\u540d\u79f0"));
        if (sb.length() != 0) {
            throw new BizException(ResponseCode.BIZ_LIST_REPEAT_OR_NULL);
        }
        if (this.dictionaryService.count((Wrapper)new QueryWrapper().in((Object)"dict_code", (Collection)list.stream().map(Dictionary::getDictCode).collect(Collectors.toList()))) > 0) {
            throw new BizException(ResponseCode.BIZ_DICT_FLAG_EXISTS);
        }
        return this.dictionaryService.saveBatch(list);
    }

    public boolean removeBatch(List<Integer> ids) {
        return this.dictionaryService.removeByIds(ids);
    }
}

