/*
 * Decompiled with CFR 0.152.
 */
package cn.slipi.admin.biz.system;

import cn.slipi.admin.common.enums.ResponseCode;
import cn.slipi.admin.common.exception.BizException;
import cn.slipi.admin.common.page.PageParam;
import cn.slipi.admin.service.system.entity.DictionaryData;
import cn.slipi.admin.service.system.service.DictionaryDataService;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import java.io.Serializable;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DictionaryDataBiz {
    @Autowired
    private DictionaryDataService dictionaryDataService;

    public List<DictionaryData> page(PageParam<DictionaryData> pageParam) {
        return this.dictionaryDataService.listPage(pageParam);
    }

    public List<DictionaryData> list(PageParam<DictionaryData> pageParam) {
        List records = this.dictionaryDataService.listAll(pageParam.getNoPageParam());
        return pageParam.sortRecords(records);
    }

    public DictionaryData get(PageParam<DictionaryData> pageParam) {
        List records = this.dictionaryDataService.listAll(pageParam.getNoPageParam());
        return (DictionaryData)pageParam.getOne(records);
    }

    public boolean add(DictionaryData dictionaryData) {
        if (this.dictionaryDataService.count((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"dict_id", (Object)dictionaryData.getDictId())).eq((Object)"dict_data_name", (Object)dictionaryData.getDictDataName())) > 0) {
            throw new BizException(ResponseCode.BIZ_DICT_ITEM_EXISTS);
        }
        if (this.dictionaryDataService.count((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"dict_id", (Object)dictionaryData.getDictId())).eq((Object)"dict_data_code", (Object)dictionaryData.getDictDataCode())) > 0) {
            throw new BizException(ResponseCode.BIZ_DICT_FLAG_EXISTS);
        }
        if (this.dictionaryDataService.save((Object)dictionaryData)) {
            return true;
        }
        throw new BizException(ResponseCode.BIZ_ADD_ERROR);
    }

    public boolean update(DictionaryData dictionaryData) {
        if (this.dictionaryDataService.count((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"dict_id", (Object)dictionaryData.getDictId())).eq((Object)"dict_data_name", (Object)dictionaryData.getDictDataName())).ne((Object)"dict_data_id", (Object)dictionaryData.getDictDataId())) > 0) {
            throw new BizException(ResponseCode.BIZ_DICT_ITEM_EXISTS);
        }
        if (this.dictionaryDataService.count((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"dict_id", (Object)dictionaryData.getDictId())).eq((Object)"dict_data_code", (Object)dictionaryData.getDictDataCode())).ne((Object)"dict_data_id", (Object)dictionaryData.getDictDataId())) > 0) {
            throw new BizException(ResponseCode.BIZ_DICT_FLAG_EXISTS);
        }
        return this.dictionaryDataService.updateById((Object)dictionaryData);
    }

    public boolean remove(Integer id) {
        return this.dictionaryDataService.removeById((Serializable)id);
    }

    public boolean saveBatch(List<DictionaryData> dictDataList) {
        return this.dictionaryDataService.saveBatch(dictDataList);
    }

    public boolean removeBatch(List<Integer> ids) {
        return this.dictionaryDataService.removeByIds(ids);
    }
}

