/*
 * Decompiled with CFR 0.152.
 */
package cn.slipi.admin.biz.system;

import cn.slipi.admin.common.util.FileServerUtil;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class FileBiz {
    @Value(value="${config.upload-location:0}")
    public Integer uploadLocation;
    @Value(value="${config.upload-uuid-name:false}")
    public Boolean uploadUuidName;
    @Value(value="${config.thumbnail-size:60}")
    public Integer thumbnailSize;
    @Value(value="${config.open-office-home:}")
    public String openOfficeHome;

    public boolean remove(String path) {
        File file;
        if (path != null && !path.trim().isEmpty() && (file = new File(this.getUploadDir(), path)).delete()) {
            return new File(this.getUploadSmDir(), path).delete();
        }
        return true;
    }

    public List<Map<String, Object>> list(String directory, String sort, String order) {
        if (directory == null || "/".equals(directory)) {
            directory = "";
        }
        File file = new File(this.getUploadDir(), directory);
        if (!directory.isEmpty() && !directory.endsWith("/")) {
            directory = directory + "/";
        }
        List list = FileServerUtil.list((File)file, (String)("file/" + directory), (String)("file/thumbnail/" + directory));
        if (sort == null || sort.trim().isEmpty()) {
            sort = "updateTime";
            if (order == null || order.trim().isEmpty()) {
                order = "desc";
            }
        }
        String finalSort = sort;
        String finalOrder = order;
        if ("length".equals(sort) || "updateTime".equals(sort)) {
            list.sort((o1, o2) -> {
                if ("desc".equals(finalOrder)) {
                    return ((Long)o2.get(finalSort)).compareTo((Long)o1.get(finalSort));
                }
                return ((Long)o1.get(finalSort)).compareTo((Long)o2.get(finalSort));
            });
        } else if ("name".equals(sort)) {
            list.sort((o1, o2) -> {
                if ("desc".equals(finalOrder)) {
                    return ((String)o2.get(finalSort)).compareTo((String)o1.get(finalSort));
                }
                return ((String)o1.get(finalSort)).compareTo((String)o2.get(finalSort));
            });
        }
        list.sort((o1, o2) -> ((Boolean)o2.get("isDirectory")).compareTo((Boolean)o1.get("isDirectory")));
        return list;
    }

    public String getBaseDir() {
        return File.listRoots()[this.uploadLocation] + "/upload/";
    }

    public String getUploadDir() {
        return this.getBaseDir() + "file/";
    }

    public String getUploadSmDir() {
        return this.getBaseDir() + "thumbnail/";
    }

    public String getPdfOutDir() {
        return this.getBaseDir() + "pdf/";
    }
}

