/*
 * Decompiled with CFR 0.152.
 */
package cn.slipi.admin.biz.system;

import cn.hutool.core.util.StrUtil;
import cn.slipi.admin.biz.system.vo.main.MenuVo;
import cn.slipi.admin.biz.system.vo.main.UserVo;
import cn.slipi.admin.common.enums.ResponseCode;
import cn.slipi.admin.common.exception.BizException;
import cn.slipi.admin.common.util.dozer.impl.ConvertBean;
import cn.slipi.admin.service.system.entity.User;
import cn.slipi.admin.service.system.service.MenuService;
import cn.slipi.admin.service.system.service.UserService;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MainBiz {
    @Autowired
    private ConvertBean convertBean;
    @Autowired
    private UserService userService;
    @Autowired
    private MenuService menuService;

    public List<MenuVo> userMenu(User loginUser) {
        List userMenu = this.menuService.getUserMenu(loginUser.getUserId(), Integer.valueOf(0));
        return this.toMenuTree(this.convertBean.convert(userMenu, MenuVo.class), Integer.valueOf(0));
    }

    public UserVo userInfo(User loginUser) {
        User user = this.userService.getFullById(loginUser.getUserId());
        return (UserVo)this.convertBean.convert((Object)user, UserVo.class);
    }

    public User updateInfo(User user, User loginUser) {
        user.setUserId(loginUser.getUserId());
        user.setState(null);
        user.setPassword(null);
        user.setUsername(null);
        user.setOrganizationId(null);
        if (this.userService.updateById((Object)user)) {
            if (user.getNickname() != null) {
                loginUser.setNickname(user.getNickname());
            }
            if (user.getAvatar() != null) {
                loginUser.setAvatar(user.getAvatar());
            }
            return this.userService.getFullById(user.getUserId());
        }
        return null;
    }

    public boolean updatePsw(String oldPsw, String newPsw, User loginUser) {
        if (StrUtil.hasBlank((CharSequence[])new CharSequence[]{oldPsw, newPsw})) {
            throw new BizException(ResponseCode.BIZ_PARAMS_CAN_NOT_NULL);
        }
        if (loginUser.getUserId() == null) {
            throw new BizException(ResponseCode.BIZ_NO_LOGIN);
        }
        if (!this.userService.comparePsw(this.userService.getById(loginUser.getUserId()).getPassword(), oldPsw)) {
            throw new BizException(ResponseCode.BIZ_OLD_PASSWORD_ERROR);
        }
        User user = new User();
        user.setUserId(loginUser.getUserId());
        user.setPassword(this.userService.encodePsw(newPsw));
        return this.userService.updateById((Object)user);
    }

    public List<MenuVo> toMenuTree(List<MenuVo> menuVoList, Integer parentId) {
        ArrayList<MenuVo> list = new ArrayList<MenuVo>();
        for (MenuVo menuVo : menuVoList) {
            if (!parentId.equals(menuVo.getParentId())) continue;
            menuVo.setChildren(this.toMenuTree(menuVoList, menuVo.getMenuId()));
            list.add(menuVo);
        }
        return list;
    }
}

