/*
 * Decompiled with CFR 0.152.
 */
package cn.slipi.admin.biz.system;

import cn.slipi.admin.common.enums.ResponseCode;
import cn.slipi.admin.common.exception.BizException;
import cn.slipi.admin.common.page.PageParam;
import cn.slipi.admin.controller.system.form.BatchForm;
import cn.slipi.admin.service.system.entity.Organization;
import cn.slipi.admin.service.system.service.OrganizationService;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.IService;
import java.io.Serializable;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;

@Component
public class OrganizationBiz {
    @Autowired
    private OrganizationService organizationService;

    public List<Organization> page(PageParam<Organization> pageParam) {
        return this.organizationService.listPage(pageParam);
    }

    public List<Organization> list(PageParam<Organization> pageParam) {
        List records = this.organizationService.listAll(pageParam.getNoPageParam());
        return pageParam.sortRecords(records);
    }

    public Organization get(PageParam<Organization> pageParam) {
        List records = this.organizationService.listAll(pageParam.getNoPageParam());
        return (Organization)pageParam.getOne(records);
    }

    public boolean add(Organization organization) {
        if (organization.getParentId() == null || organization.getParentId() == 0) {
            organization.setParentId(Integer.valueOf(0));
            if (this.organizationService.count((Wrapper)new QueryWrapper().eq((Object)"parent_id", (Object)0)) > 0) {
                throw new BizException(ResponseCode.BIZ_ORG_ROOT_ERROR);
            }
        }
        if (this.organizationService.count((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"organization_name", (Object)organization.getOrganizationName())).eq((Object)"parent_id", (Object)organization.getParentId())) > 0) {
            throw new BizException(ResponseCode.BIZ_ORG_NAME_EXISTS);
        }
        Organization parentOrganization = (Organization)this.organizationService.getById((Serializable)organization.getParentId());
        if (parentOrganization != null) {
            if (parentOrganization.getLevel() == 3) {
                throw new BizException(ResponseCode.BIZ_ORG_LEVEL_ERROR);
            }
            organization.setLevel(Integer.valueOf(parentOrganization.getLevel() + 1));
        } else {
            organization.setLevel(Integer.valueOf(1));
        }
        return this.organizationService.save((Object)organization);
    }

    public boolean update(@RequestBody Organization organization) {
        Organization parentOrganization;
        if (organization.getOrganizationName() != null) {
            if (organization.getParentId() == null || organization.getParentId() == 0) {
                organization.setParentId(Integer.valueOf(0));
                if (this.organizationService.count((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"parent_id", (Object)0)).ne((Object)"organization_id", (Object)organization.getOrganizationId())) > 0) {
                    throw new BizException(ResponseCode.BIZ_ORG_ROOT_ERROR);
                }
            }
            if (this.organizationService.count((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"organization_name", (Object)organization.getOrganizationName())).eq((Object)"parent_id", (Object)organization.getParentId())).ne((Object)"organization_id", (Object)organization.getOrganizationId())) > 0) {
                throw new BizException(ResponseCode.BIZ_ORG_NAME_EXISTS);
            }
        }
        if ((parentOrganization = (Organization)this.organizationService.getById((Serializable)organization.getParentId())) != null) {
            if (parentOrganization.getLevel() == 3) {
                throw new BizException(ResponseCode.BIZ_ORG_LEVEL_ERROR);
            }
            organization.setLevel(Integer.valueOf(parentOrganization.getLevel() + 1));
        } else {
            organization.setLevel(Integer.valueOf(1));
        }
        return this.organizationService.updateById((Object)organization);
    }

    public boolean remove(@PathVariable(value="id") Integer id) {
        if (this.organizationService.count((Wrapper)new QueryWrapper().eq((Object)"parent_id", (Object)id)) > 0) {
            throw new BizException(ResponseCode.BIZ_ORG_SUB_ERROR);
        }
        return this.organizationService.removeById((Serializable)id);
    }

    public boolean saveBatch(@RequestBody List<Organization> organizationList) {
        return this.organizationService.saveBatch(organizationList);
    }

    public boolean updateBatch(@RequestBody BatchForm<Organization> batchForm) {
        return batchForm.update((IService)this.organizationService, "organization_id");
    }

    public boolean removeBatch(@RequestBody List<Integer> ids) {
        return this.organizationService.removeByIds(ids);
    }
}

