/*
 * Decompiled with CFR 0.152.
 */
package cn.slipi.admin.biz.system;

import cn.slipi.admin.common.enums.ResponseCode;
import cn.slipi.admin.common.exception.BizException;
import cn.slipi.admin.common.page.PageParam;
import cn.slipi.admin.common.util.CoreUtil;
import cn.slipi.admin.service.system.entity.Role;
import cn.slipi.admin.service.system.service.RoleMenuService;
import cn.slipi.admin.service.system.service.RoleService;
import cn.slipi.admin.service.system.service.UserRoleService;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RoleBiz {
    public static final String SYSTEM_ROLE_CODE = "admin";
    @Autowired
    private RoleService roleService;
    @Autowired
    private RoleMenuService roleMenuService;
    @Autowired
    private UserRoleService userRoleService;

    public List<Role> page(PageParam<Role> pageParam) {
        return ((PageParam)this.roleService.page(pageParam, (Wrapper)pageParam.getWrapper(new String[0]))).getRecords();
    }

    public List<Role> list(PageParam<Role> pageParam) {
        return this.roleService.list((Wrapper)pageParam.getOrderWrapper());
    }

    public Role getById(Integer id) {
        return (Role)this.roleService.getById((Serializable)id);
    }

    public boolean save(Role role) {
        if (this.roleService.count((Wrapper)new QueryWrapper().eq((Object)"role_code", (Object)role.getRoleCode())) > 0) {
            throw new BizException(ResponseCode.BIZ_ROLE_FLAG_EXISTS);
        }
        if (this.roleService.count((Wrapper)new QueryWrapper().eq((Object)"role_name", (Object)role.getRoleName())) > 0) {
            throw new BizException(ResponseCode.BIZ_ROLE_NAME_EXISTS);
        }
        return this.roleService.save((Object)role);
    }

    public boolean update(Role role) {
        if (role.getRoleCode() != null && this.roleService.count((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"role_code", (Object)role.getRoleCode())).ne((Object)"role_id", (Object)role.getRoleId())) > 0) {
            throw new BizException(ResponseCode.BIZ_ROLE_FLAG_EXISTS);
        }
        if (role.getRoleName() != null && this.roleService.count((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"role_name", (Object)role.getRoleName())).ne((Object)"role_id", (Object)role.getRoleId())) > 0) {
            throw new BizException(ResponseCode.BIZ_ROLE_NAME_EXISTS);
        }
        return this.roleService.updateById((Object)role);
    }

    public boolean removeById(Integer id) {
        Role role = (Role)this.roleService.getById((Serializable)id);
        if (SYSTEM_ROLE_CODE.equals(role.getRoleCode())) {
            throw new BizException(ResponseCode.BIZ_ROLE_CANNOT_DEL);
        }
        if (this.roleMenuService.countByRoleId(id) > 0 || this.userRoleService.countByRoleId(id) > 0) {
            throw new BizException(ResponseCode.BIZ_ROLE_CANNOT_DEL_BY_RELATIVE);
        }
        return this.roleService.removeById((Serializable)id);
    }

    public boolean removeByIds(List<Integer> ids) {
        return this.roleService.removeByIds(ids);
    }

    public boolean saveBatch(List<Role> list) {
        StringBuilder sb = new StringBuilder();
        sb.append(CoreUtil.listCheckBlank(list, (String)"roleCode", (String)"\u89d2\u8272\u6807\u8bc6"));
        sb.append(CoreUtil.listCheckBlank(list, (String)"roleName", (String)"\u89d2\u8272\u540d\u79f0"));
        sb.append(CoreUtil.listCheckRepeat(list, (String)"roleCode", (String)"\u89d2\u8272\u6807\u8bc6"));
        sb.append(CoreUtil.listCheckRepeat(list, (String)"roleName", (String)"\u89d2\u8272\u540d\u79f0"));
        if (sb.length() != 0) {
            throw new BizException(ResponseCode.BIZ_PARAMS_CAN_NOT_NULL);
        }
        if (this.roleService.count((Wrapper)new QueryWrapper().in((Object)"role_code", (Collection)list.stream().map(Role::getRoleCode).collect(Collectors.toList()))) > 0) {
            throw new BizException(ResponseCode.BIZ_ROLE_FLAG_EXISTS);
        }
        return this.roleService.saveBatch(list);
    }
}

