/*
 * Decompiled with CFR 0.152.
 */
package cn.slipi.admin.biz.system;

import cn.hutool.core.util.StrUtil;
import cn.hutool.poi.excel.ExcelReader;
import cn.hutool.poi.excel.ExcelUtil;
import cn.slipi.admin.biz.system.vo.user.UserVo;
import cn.slipi.admin.common.enums.ResponseCode;
import cn.slipi.admin.common.exception.BizException;
import cn.slipi.admin.common.page.PageParam;
import cn.slipi.admin.common.util.CoreUtil;
import cn.slipi.admin.common.util.dozer.impl.ConvertBean;
import cn.slipi.admin.controller.system.form.BatchForm;
import cn.slipi.admin.controller.system.form.user.AddForm;
import cn.slipi.admin.controller.system.form.user.UpdateForm;
import cn.slipi.admin.service.system.entity.DictionaryData;
import cn.slipi.admin.service.system.entity.Organization;
import cn.slipi.admin.service.system.entity.Role;
import cn.slipi.admin.service.system.entity.User;
import cn.slipi.admin.service.system.service.DictionaryDataService;
import cn.slipi.admin.service.system.service.OrganizationService;
import cn.slipi.admin.service.system.service.RoleService;
import cn.slipi.admin.service.system.service.UserService;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.IService;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;

@Component
public class UserBiz {
    @Autowired
    private ConvertBean convertBean;
    @Autowired
    private UserService userService;
    @Autowired
    private RoleService roleService;
    @Autowired
    private DictionaryDataService dictionaryDataService;
    @Autowired
    private OrganizationService organizationService;

    public List<UserVo> page(PageParam<User> pageParam) {
        pageParam.setDefaultOrder(null, new String[]{"create_time"});
        List userList = this.userService.listPage(pageParam);
        return this.convertBean.convert(userList, UserVo.class);
    }

    public List<UserVo> list(PageParam<User> pageParam) {
        List userList = this.userService.listAll(pageParam.getNoPageParam());
        List sortUserList = pageParam.sortRecords(userList);
        return this.convertBean.convert(sortUserList, UserVo.class);
    }

    public UserVo getById(Integer id) {
        User user = this.userService.getById(id);
        if (user == null) {
            throw new BizException(ResponseCode.BIZ_RECORD_NOT_FOUND);
        }
        return (UserVo)this.convertBean.convert((Object)user, UserVo.class);
    }

    public boolean add(AddForm form) {
        User user = (User)this.convertBean.convert((Object)form, User.class);
        user.setState(Integer.valueOf(0));
        user.setPassword(this.userService.encodePsw(user.getPassword()));
        return this.userService.saveUser(user);
    }

    public boolean update(User user) {
        user.setPassword(this.userService.encodePsw(user.getPassword()));
        return this.userService.updateUser(user);
    }

    public boolean updateById(Integer id, UpdateForm updateForm) {
        User cUser = this.userService.getById(id);
        if (cUser == null) {
            throw new BizException(ResponseCode.BIZ_RECORD_NOT_FOUND);
        }
        this.convertBean.convert((Object)updateForm, (Object)cUser);
        return this.userService.updateInfo(cUser);
    }

    public boolean initPass(Integer id) {
        User user = this.userService.getById(id);
        user.setPassword(this.userService.encodePsw("123456"));
        return this.userService.updateInfo(user);
    }

    public boolean remove(Integer id, User user) {
        if (user != null && user.getUserId().equals(id)) {
            throw new BizException(ResponseCode.BIZ_CAN_NOT_DEL_SELF);
        }
        return this.userService.removeById(id);
    }

    public boolean removeBatch(BatchForm<User> batchForm) {
        return batchForm.update((IService)this.userService, "user_id");
    }

    public boolean deleteBatch(List<Integer> ids) {
        return this.userService.removeByIds(ids);
    }

    public boolean updateState(Integer id, Integer state, User loginUser) {
        if (state == null || state != 0 && state != 1) {
            throw new BizException(ResponseCode.BIZ_STATE_ERROR);
        }
        if (loginUser != null && loginUser.getUserId().equals(id) && state == 1) {
            throw new BizException(ResponseCode.BIZ_CAN_NOT_STATE_SELF);
        }
        User user = new User();
        user.setUserId(id);
        user.setState(state);
        return this.userService.updateById((Object)user);
    }

    public boolean updateStateBatch(BatchForm<User> batchForm) {
        User user = new User();
        user.setState(((User)batchForm.getData()).getState());
        if (user.getState() == null || user.getState() != 0 && user.getState() != 1) {
            throw new BizException(ResponseCode.BIZ_STATE_ERROR);
        }
        return batchForm.update((IService)this.userService, "user_id");
    }

    public boolean resetPsw(Integer id, String password) {
        User user = new User();
        user.setUserId(id);
        user.setPassword(this.userService.encodePsw(password));
        return this.userService.updateById((Object)user);
    }

    public boolean resetPswBatch(BatchForm<User> batchForm) {
        User user = new User();
        user.setPassword(this.userService.encodePsw(((User)batchForm.getData()).getPassword()));
        return batchForm.update((IService)this.userService, "user_id");
    }

    public String importBatch(MultipartFile file) {
        StringBuilder sb = new StringBuilder();
        try {
            int startRow = 1;
            ExcelReader reader = ExcelUtil.getReader((InputStream)file.getInputStream(), (int)0);
            List list = reader.read(startRow);
            sb.append(CoreUtil.excelCheckBlank((List)list, (int)startRow, (int[])new int[]{0, 1, 2, 3, 4, 7}));
            sb.append(CoreUtil.excelCheckRepeat((List)list, (int)startRow, (int[])new int[]{0, 5, 6}));
            if (!sb.toString().isEmpty()) {
                throw new BizException(sb.toString());
            }
            ArrayList<User> users = new ArrayList<User>();
            for (int i = 0; i < list.size(); ++i) {
                List objects = (List)list.get(i);
                String username = String.valueOf(objects.get(0));
                String password = String.valueOf(objects.get(1));
                String nickname = String.valueOf(objects.get(2));
                String sexName = String.valueOf(objects.get(3));
                String roleName = String.valueOf(objects.get(4));
                String phone = String.valueOf(objects.get(5));
                String email = String.valueOf(objects.get(6));
                String orgName = String.valueOf(objects.get(7));
                if (this.userService.count((Wrapper)new QueryWrapper().eq((Object)"username", (Object)username)) > 0) {
                    sb.append("\u7b2c");
                    sb.append(i + startRow + 1);
                    sb.append("\u884c\u7b2c1");
                    sb.append("\u5217\u8d26\u53f7\u5df2\u5b58\u5728;\r\n");
                }
                if (StrUtil.isNotBlank((CharSequence)phone) && this.userService.count((Wrapper)new QueryWrapper().eq((Object)"phone", (Object)phone)) > 0) {
                    sb.append("\u7b2c");
                    sb.append(i + startRow + 1);
                    sb.append("\u884c\u7b2c6");
                    sb.append("\u5217\u624b\u673a\u53f7\u5df2\u5b58\u5728;\r\n");
                }
                if (StrUtil.isNotBlank((CharSequence)email) && this.userService.count((Wrapper)new QueryWrapper().eq((Object)"email", (Object)email)) > 0) {
                    sb.append("\u7b2c");
                    sb.append(i + startRow + 1);
                    sb.append("\u884c\u7b2c7");
                    sb.append("\u5217\u90ae\u7bb1\u5df2\u5b58\u5728;\r\n");
                }
                User user = new User();
                user.setUsername(username);
                user.setNickname(nickname);
                user.setPassword(this.userService.encodePsw(password));
                user.setState(Integer.valueOf(0));
                user.setPhone(phone);
                user.setEmail(email);
                DictionaryData sexDictData = this.dictionaryDataService.listByDictCodeAndName("sex", sexName);
                if (sexDictData == null) {
                    sb.append("\u7b2c");
                    sb.append(i + startRow + 1);
                    sb.append("\u884c\u7b2c4");
                    sb.append("\u5217\u6027\u522b\u4e0d\u5b58\u5728;\r\n");
                } else {
                    user.setSex(sexDictData.getDictDataId());
                }
                Role role = (Role)this.roleService.getOne((Wrapper)new QueryWrapper().eq((Object)"role_name", (Object)roleName), false);
                if (role == null) {
                    sb.append("\u7b2c");
                    sb.append(i + startRow + 1);
                    sb.append("\u884c\u7b2c5");
                    sb.append("\u5217\u89d2\u8272\u4e0d\u5b58\u5728;\r\n");
                } else {
                    user.setRoleIds(Collections.singletonList(role.getRoleId()));
                }
                Organization org = (Organization)this.organizationService.getOne((Wrapper)new QueryWrapper().eq((Object)"organization_full_name", (Object)orgName), false);
                if (org == null) {
                    sb.append("\u7b2c");
                    sb.append(i + startRow + 1);
                    sb.append("\u884c\u7b2c8");
                    sb.append("\u5217\u673a\u6784\u4e0d\u5b58\u5728;\r\n");
                } else {
                    user.setOrganizationId(org.getOrganizationId());
                }
                users.add(user);
            }
            if (!sb.toString().isEmpty()) {
                throw new BizException(sb.toString());
            }
            int okNum = 0;
            int errorNum = 0;
            for (User user : users) {
                if (this.userService.saveUser(user)) {
                    ++okNum;
                    continue;
                }
                ++errorNum;
            }
            return String.format("\u5bfc\u5165\u5b8c\u6210\uff0c\u6210\u529f%d\u6761\uff0c\u5931\u8d25%d\u6761", okNum, errorNum);
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
    }
}

