/*
 * Decompiled with CFR 0.152.
 */
package cn.slipi.admin.common.aspect;

import java.lang.reflect.Method;
import java.util.Date;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class UsedTimeAspect {
    private static final Logger logger = LoggerFactory.getLogger(UsedTimeAspect.class);

    @Pointcut(value="@annotation(cn.slipi.admin.common.annotation.UsedTime)")
    public void pointCut() {
    }

    @Around(value="pointCut()")
    public Object aroundHandler(ProceedingJoinPoint joinPoint) throws Throwable {
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        Method method = signature.getMethod();
        String methodName = method.getName();
        long startTime = System.currentTimeMillis();
        Object obj = joinPoint.proceed();
        long endTime = System.currentTimeMillis();
        logger.info("\u5f53\u524d\u65f6\u95f4:" + new Date() + ", \u65b9\u6cd5:" + methodName + "(),\u5f53\u524d\u6d88\u8017\u65f6\u95f4:" + (endTime - startTime) + "ms," + (endTime - startTime) / 1000L + "s");
        return obj;
    }
}

