/*
 * Decompiled with CFR 0.152.
 */
package cn.slipi.admin.common.config;

import cn.hutool.core.util.StrUtil;
import java.util.HashSet;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.JedisPoolConfig;

@Configuration
public class RedisConfiguration {
    private static final Logger log = LoggerFactory.getLogger(RedisConfiguration.class);
    @Value(value="${redis.nodes}")
    private String clusterNodes;
    @Value(value="${redis.password}")
    private String password;
    @Value(value="${redis.timeout}")
    private Integer timeout;
    @Value(value="${redis.soTimeout}")
    private Integer soTimeout;
    @Value(value="${redis.maxAttempts}")
    private Integer maxAttempts;
    @Value(value="${redis.minIdle}")
    private Integer minIdle;
    @Value(value="${redis.maxIdle}")
    private Integer maxIdle;
    @Value(value="${redis.maxTotal}")
    private Integer maxTotal;
    @Value(value="${redis.maxWaitMillis}")
    private Integer maxWaitMillis;
    @Value(value="${redis.testOnBorrow}")
    private boolean testOnBorrow;
    @Value(value="${redis.blockWhenExhausted}")
    private boolean blockWhenExhausted;

    @Bean
    public JedisCluster getJedisCluster(GenericObjectPoolConfig genericObjectPoolConfig) {
        String[] cNodes = this.clusterNodes.split(",");
        HashSet<HostAndPort> nodes = new HashSet<HostAndPort>();
        for (String node : cNodes) {
            String[] hp = node.split(":");
            nodes.add(new HostAndPort(hp[0], Integer.parseInt(hp[1])));
        }
        if (StrUtil.isEmpty((CharSequence)this.password)) {
            return new JedisCluster(nodes, this.timeout.intValue(), this.soTimeout.intValue(), this.maxAttempts.intValue(), genericObjectPoolConfig);
        }
        return new JedisCluster(nodes, this.timeout.intValue(), this.soTimeout.intValue(), this.maxAttempts.intValue(), this.password, genericObjectPoolConfig);
    }

    @Bean
    public JedisPoolConfig jedisPoolConfig() {
        JedisPoolConfig jedisPoolConfig = new JedisPoolConfig();
        jedisPoolConfig.setMaxTotal(this.maxTotal.intValue());
        jedisPoolConfig.setMaxIdle(this.maxIdle.intValue());
        jedisPoolConfig.setMinIdle(this.minIdle.intValue());
        jedisPoolConfig.setMaxWaitMillis((long)this.maxWaitMillis.intValue());
        jedisPoolConfig.setTestOnBorrow(this.testOnBorrow);
        jedisPoolConfig.setBlockWhenExhausted(this.blockWhenExhausted);
        return jedisPoolConfig;
    }

    @Bean
    public GenericObjectPoolConfig genericObjectPoolConfig() {
        GenericObjectPoolConfig genericObjectPoolConfig = new GenericObjectPoolConfig();
        genericObjectPoolConfig.setMaxTotal(this.maxTotal.intValue());
        genericObjectPoolConfig.setMaxIdle(this.maxIdle.intValue());
        genericObjectPoolConfig.setMinIdle(this.minIdle.intValue());
        genericObjectPoolConfig.setMaxWaitMillis((long)this.maxWaitMillis.intValue());
        genericObjectPoolConfig.setTestOnBorrow(this.testOnBorrow);
        genericObjectPoolConfig.setBlockWhenExhausted(this.blockWhenExhausted);
        return genericObjectPoolConfig;
    }
}

