/*
 * Decompiled with CFR 0.152.
 */
package cn.slipi.admin.common.config;

import cn.slipi.admin.common.config.security.UserDetailsServiceImpl;
import cn.slipi.admin.common.filter.JwtLoginFilter;
import cn.slipi.admin.common.filter.JwtRequestFilter;
import cn.slipi.admin.common.handler.JwtExceptionHandler;
import cn.slipi.admin.common.handler.JwtLogoutSuccessHandler;
import javax.servlet.Filter;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpMethod;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.method.configuration.EnableGlobalMethodSecurity;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.builders.WebSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.access.AccessDeniedHandler;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;

@Configuration
@EnableWebSecurity
@EnableGlobalMethodSecurity(prePostEnabled=true)
public class SecurityConfiguration
extends WebSecurityConfigurerAdapter {
    protected void configure(HttpSecurity http) throws Exception {
        ((HttpSecurity)((HttpSecurity)((HttpSecurity)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.authorizeRequests().antMatchers(HttpMethod.OPTIONS, new String[]{"/**"})).permitAll().antMatchers(HttpMethod.GET, new String[]{this.admin("/file/**"), this.admin("/"), "/favicon.ico", "/assets/**", "/**.html"})).permitAll().antMatchers(new String[]{this.admin("/login"), this.admin("/error"), this.client("/**"), "/webjars/**"})).permitAll().anyRequest()).authenticated().and()).sessionManagement().sessionCreationPolicy(SessionCreationPolicy.STATELESS).and()).headers().frameOptions().disable().and()).cors().and()).csrf().disable();
        http.exceptionHandling().accessDeniedHandler((AccessDeniedHandler)this.jwtExceptionHandler()).authenticationEntryPoint((AuthenticationEntryPoint)this.jwtExceptionHandler());
        http.logout().logoutUrl("/logout").logoutSuccessHandler((LogoutSuccessHandler)this.jwtLogoutSuccessHandler());
        http.addFilterBefore((Filter)this.jwtLoginFilter(), UsernamePasswordAuthenticationFilter.class);
        http.addFilterBefore((Filter)this.jwtRequestFilter(), UsernamePasswordAuthenticationFilter.class);
    }

    private String admin(String path) {
        return "/api/" + path;
    }

    private String client(String path) {
        return "client/" + path;
    }

    public void configure(WebSecurity web) {
        web.ignoring().antMatchers(new String[]{"/client/**"});
        web.ignoring().antMatchers(new String[]{"/api/file/captcha"});
    }

    protected void configure(AuthenticationManagerBuilder auth) throws Exception {
        auth.userDetailsService((UserDetailsService)this.userDetailsServiceImpl()).passwordEncoder((PasswordEncoder)this.bCryptPasswordEncoder());
    }

    @Bean
    public AuthenticationManager authenticationManagerBean() throws Exception {
        return super.authenticationManagerBean();
    }

    @Bean
    public BCryptPasswordEncoder bCryptPasswordEncoder() {
        return new BCryptPasswordEncoder();
    }

    @Bean
    public UserDetailsServiceImpl userDetailsServiceImpl() {
        return new UserDetailsServiceImpl();
    }

    @Bean
    public JwtLoginFilter jwtLoginFilter() throws Exception {
        return new JwtLoginFilter(this.authenticationManagerBean());
    }

    @Bean
    public JwtRequestFilter jwtRequestFilter() {
        return new JwtRequestFilter((UserDetailsService)this.userDetailsServiceImpl());
    }

    @Bean
    public JwtLogoutSuccessHandler jwtLogoutSuccessHandler() {
        return new JwtLogoutSuccessHandler();
    }

    @Bean
    public JwtExceptionHandler jwtExceptionHandler() {
        return new JwtExceptionHandler();
    }
}

