/*
 * Decompiled with CFR 0.152.
 */
package cn.slipi.admin.common.config;

import cn.slipi.admin.common.handler.BizExceptionHandler;
import cn.slipi.admin.common.handler.DefaultExceptionHandler;
import cn.slipi.admin.common.interceptor.CheckRepeatInterceptor;
import cn.slipi.admin.common.interceptor.GateInterceptor;
import cn.slipi.admin.common.interceptor.SignVerifyInterceptor;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.HandlerExceptionResolver;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.CorsRegistry;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurationSupport;

@Configuration
public class WebConfiguration
extends WebMvcConfigurationSupport {
    private static final String PATH_ALL_PATTERN = "/**";
    private static final String PATH_API_PATTERN = "//api/**";
    @Autowired
    private GateInterceptor gateInterceptor;
    @Autowired
    private SignVerifyInterceptor signVerifyInterceptor;
    @Autowired
    private CheckRepeatInterceptor checkRepeatInterceptor;
    @Autowired
    private BizExceptionHandler bizExceptionHandler;
    @Autowired
    private DefaultExceptionHandler defaultExceptionHandler;

    protected void configureHandlerExceptionResolvers(List<HandlerExceptionResolver> exceptionResolvers) {
        exceptionResolvers.add((HandlerExceptionResolver)this.bizExceptionHandler);
        exceptionResolvers.add((HandlerExceptionResolver)this.defaultExceptionHandler);
    }

    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor((HandlerInterceptor)this.gateInterceptor).addPathPatterns(new String[]{PATH_API_PATTERN});
        registry.addInterceptor((HandlerInterceptor)this.signVerifyInterceptor).addPathPatterns(new String[]{PATH_ALL_PATTERN});
        registry.addInterceptor((HandlerInterceptor)this.checkRepeatInterceptor).addPathPatterns(new String[]{PATH_ALL_PATTERN});
        super.addInterceptors(registry);
    }

    protected void addCorsMappings(CorsRegistry registry) {
        registry.addMapping(PATH_ALL_PATTERN).maxAge(3600L).allowedMethods(new String[]{"GET", "POST", "PUT", "DELETE", "OPTIONS"}).allowedHeaders(new String[]{"Content-Type", "x-requested-with", "X-Custom-Header", "Authorization", "timestamp", "sign"});
    }

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
    }
}

