/*
 * Decompiled with CFR 0.152.
 */
package cn.slipi.admin.common.filter;

import cn.slipi.admin.common.constants.Constants;
import cn.slipi.admin.common.enums.ResponseCode;
import cn.slipi.admin.common.response.JsonResponse;
import cn.slipi.admin.common.util.JsonUtil;
import cn.slipi.admin.common.util.JwtUtil;
import cn.slipi.admin.service.system.service.LoginRecordService;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Objects;
import javax.servlet.FilterChain;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.LockedException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;

public class JwtLoginFilter
extends UsernamePasswordAuthenticationFilter {
    @Autowired
    private LoginRecordService loginRecordService;

    public JwtLoginFilter(AuthenticationManager authenticationManager) {
        super.setAuthenticationManager(authenticationManager);
        super.setFilterProcessesUrl("/api/login");
    }

    protected void successfulAuthentication(HttpServletRequest request, HttpServletResponse response, FilterChain chain, Authentication authResult) throws IOException {
        UserDetails user = (UserDetails)authResult.getPrincipal();
        String accessToken = JwtUtil.buildToken((String)user.getUsername(), (Long)Constants.TOKEN_EXPIRE_TIME, (String)"ULgNsWJ8rPjRtnjzX/Gv2RGS80Ksnm/ZaLpvIL+NrBg=");
        this.loginRecordService.saveAsync(user.getUsername(), Integer.valueOf(0), null, request);
        response.setContentType("application/json;charset=UTF-8");
        PrintWriter out = response.getWriter();
        out.write(Objects.requireNonNull(JsonUtil.object2Json((Object)Objects.requireNonNull(JsonResponse.ok().put("access_token", (Object)accessToken)).put("token_type", (Object)"Bearer"))));
        out.flush();
    }

    protected void unsuccessfulAuthentication(HttpServletRequest request, HttpServletResponse response, AuthenticationException e) throws IOException {
        String username = request.getParameter("username");
        response.setContentType("application/json;charset=UTF-8");
        PrintWriter out = response.getWriter();
        String message = "";
        message = e instanceof UsernameNotFoundException ? ResponseCode.BIZ_ACCOUNT_NOT_EXISTS.msg() : (e instanceof BadCredentialsException ? ResponseCode.BIZ_ACCOUNT_PASSWORD_ERROR.msg() : (e instanceof LockedException ? ResponseCode.BIZ_ACCOUNT_LOCKED.msg() : e.getMessage()));
        this.loginRecordService.saveAsync(username, Integer.valueOf(1), message, request);
        out.write(JsonUtil.object2Json((Object)JsonResponse.fail((String)message)));
        out.flush();
    }
}

