/*
 * Decompiled with CFR 0.152.
 */
package cn.slipi.admin.common.filter;

import cn.slipi.admin.common.constants.Constants;
import cn.slipi.admin.common.util.JwtUtil;
import cn.slipi.admin.common.util.cache.JedisClusterUtil;
import cn.slipi.admin.service.system.service.LoginRecordService;
import io.jsonwebtoken.Claims;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.web.filter.OncePerRequestFilter;

public class JwtRequestFilter
extends OncePerRequestFilter {
    private final UserDetailsService userDetailsService;
    @Autowired
    private JedisClusterUtil jedisClusterUtil;
    @Autowired
    private LoginRecordService loginRecordService;

    public JwtRequestFilter(UserDetailsService userDetailsService) {
        this.userDetailsService = userDetailsService;
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws ServletException, IOException {
        String accessToken = JwtUtil.getAccessToken((HttpServletRequest)request);
        if (accessToken != null) {
            try {
                Claims claims = JwtUtil.parseToken((String)accessToken, (String)"ULgNsWJ8rPjRtnjzX/Gv2RGS80Ksnm/ZaLpvIL+NrBg=");
                String username = claims.getSubject();
                UserDetails userDetails = this.userDetailsService.loadUserByUsername(username);
                UsernamePasswordAuthenticationToken authentication = new UsernamePasswordAuthenticationToken((Object)userDetails, null, userDetails.getAuthorities());
                SecurityContextHolder.getContext().setAuthentication((Authentication)authentication);
                if ((claims.getExpiration().getTime() - System.currentTimeMillis()) / 1000L / 60L < 10L && this.jedisClusterUtil.setNx(accessToken, username, 0)) {
                    String accessTokenNew = JwtUtil.buildToken((String)username, (Long)Constants.TOKEN_EXPIRE_TIME, (String)"ULgNsWJ8rPjRtnjzX/Gv2RGS80Ksnm/ZaLpvIL+NrBg=");
                    response.setHeader("Access-Control-Expose-Headers", "Authorization");
                    response.addHeader("Authorization", accessTokenNew);
                    this.loginRecordService.saveAsync(username, Integer.valueOf(3), null, request);
                    this.jedisClusterUtil.deleteKey(accessToken);
                }
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }
}

