/*
 * Decompiled with CFR 0.152.
 */
package cn.slipi.admin.common.handler;

import cn.slipi.admin.common.exception.BizException;
import cn.slipi.admin.common.response.ErrorResponse;
import cn.slipi.admin.common.response.builder.ResponseBuilder;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.HandlerExceptionResolver;
import org.springframework.web.servlet.ModelAndView;

@Component
public class BizExceptionHandler
implements HandlerExceptionResolver {
    private static final Logger log = LoggerFactory.getLogger(BizExceptionHandler.class);

    public ModelAndView resolveException(HttpServletRequest request, HttpServletResponse response, Object o, Exception e) {
        if (e instanceof BizException) {
            response.setStatus(HttpStatus.OK.value());
            BizException bizException = (BizException)e;
            ErrorResponse error = ErrorResponse.error((int)bizException.getCode(), (String)bizException.getMsg(), (Throwable)e);
            log.warn("URL:{},{}\uff01", new Object[]{request.getRequestURI(), bizException.getMsg(), e});
            return ResponseBuilder.build((Object)error);
        }
        return null;
    }
}

