/*
 * Decompiled with CFR 0.152.
 */
package cn.slipi.admin.common.handler;

import cn.slipi.admin.common.enums.ResponseCode;
import cn.slipi.admin.common.response.ErrorResponse;
import cn.slipi.admin.common.response.builder.ResponseBuilder;
import cn.slipi.admin.common.util.JsonUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.stereotype.Component;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.servlet.HandlerExceptionResolver;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.NoHandlerFoundException;

@Component
public class DefaultExceptionHandler
implements HandlerExceptionResolver {
    private static final Logger log = LoggerFactory.getLogger(DefaultExceptionHandler.class);

    public ModelAndView resolveException(HttpServletRequest request, HttpServletResponse response, Object o, Exception e) {
        if (e instanceof MethodArgumentNotValidException) {
            response.setStatus(HttpStatus.OK.value());
            ErrorResponse error = ErrorResponse.error((ResponseCode)ResponseCode.SYSTEM_PARAM_IS_INVALID, (Throwable)e, (String)this.methodArgumentNotValid(e));
            log.error("URL:{},{}\uff01", new Object[]{request.getRequestURI(), ResponseCode.SYSTEM_PARAM_IS_INVALID.msg(), e});
            return ResponseBuilder.build((Object)error);
        }
        if (e instanceof ConstraintViolationException) {
            response.setStatus(ResponseCode.SYSTEM_PARAM_IS_INVALID.code().intValue());
            ErrorResponse error = ErrorResponse.error((ResponseCode)ResponseCode.SYSTEM_PARAM_IS_INVALID, (Throwable)e, (String)this.constraintViolation(e));
            log.error("URL:{},{}\uff01", new Object[]{request.getRequestURI(), ResponseCode.SYSTEM_PARAM_IS_INVALID.msg(), e});
            return ResponseBuilder.build((Object)error);
        }
        if (e instanceof MissingServletRequestParameterException) {
            response.setStatus(HttpStatus.OK.value());
            MissingServletRequestParameterException msr = (MissingServletRequestParameterException)e;
            ErrorResponse error = ErrorResponse.error((ResponseCode)ResponseCode.SYSTEM_PARAM_IS_INVALID, (Throwable)e, (String)String.format("[%s]\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a", msr.getParameterName()));
            log.error("URL:{},{}\uff01", new Object[]{request.getRequestURI(), ResponseCode.SYSTEM_PARAM_IS_INVALID.msg(), e});
            return ResponseBuilder.build((Object)error);
        }
        if (e instanceof NoHandlerFoundException) {
            response.setStatus(ResponseCode.SYSTEM_NOT_FOUND.code().intValue());
            log.error("URL:{},{}\uff01", new Object[]{request.getRequestURI(), ResponseCode.SYSTEM_NOT_FOUND.msg(), e});
            return ResponseBuilder.build((Object)ErrorResponse.error((ResponseCode)ResponseCode.SYSTEM_NOT_FOUND, (Throwable)e));
        }
        if (e instanceof AccessDeniedException) {
            response.setStatus(HttpStatus.OK.value());
            log.error("URL:{},{}\uff01", new Object[]{request.getRequestURI(), ResponseCode.SYSTEM_ACCESS_ERROR.msg(), e});
            return ResponseBuilder.build((Object)ErrorResponse.error((ResponseCode)ResponseCode.SYSTEM_ACCESS_ERROR, (Throwable)e));
        }
        if (e instanceof HttpMessageNotReadableException) {
            response.setStatus(ResponseCode.SYSTEM_PARAMS_JSON_ERROR.code().intValue());
            log.error("URL:{},{}\uff01", new Object[]{request.getRequestURI(), ResponseCode.SYSTEM_PARAMS_JSON_ERROR.msg(), e});
            return ResponseBuilder.build((Object)ErrorResponse.error((ResponseCode)ResponseCode.SYSTEM_PARAMS_JSON_ERROR, (Throwable)e));
        }
        response.setStatus(ResponseCode.SYSTEM_ERROR.code().intValue());
        ErrorResponse error = ErrorResponse.error((ResponseCode)ResponseCode.SYSTEM_ERROR, (Throwable)e);
        log.error("URL:{},{}\uff01", new Object[]{request.getRequestURI(), ResponseCode.SYSTEM_ERROR.msg(), e});
        return ResponseBuilder.build((Object)error);
    }

    private String methodArgumentNotValid(Exception e) {
        MethodArgumentNotValidException ex = (MethodArgumentNotValidException)e;
        List fieldErrors = ex.getBindingResult().getFieldErrors();
        ArrayList info = new ArrayList();
        for (FieldError obj : fieldErrors) {
            HashMap<String, String> single = new HashMap<String, String>();
            single.put(obj.getField(), obj.getDefaultMessage());
            info.add(single);
        }
        return JsonUtil.object2Json(info);
    }

    private String constraintViolation(Exception e) {
        ConstraintViolationException vex = (ConstraintViolationException)e;
        Set constraintViolations = vex.getConstraintViolations();
        StringBuilder sbf = new StringBuilder();
        for (ConstraintViolation violation : constraintViolations) {
            String message = violation.getMessage();
            if (!StringUtils.isNotBlank((CharSequence)message)) continue;
            sbf.append(violation.getMessage());
        }
        return sbf.toString();
    }
}

