/*
 * Decompiled with CFR 0.152.
 */
package cn.slipi.admin.common.handler;

import cn.slipi.admin.common.enums.ResponseCode;
import cn.slipi.admin.common.response.ErrorResponse;
import cn.slipi.admin.common.util.JsonUtil;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.authentication.AccountExpiredException;
import org.springframework.security.authentication.InsufficientAuthenticationException;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.access.AccessDeniedHandler;

public class JwtExceptionHandler
implements AccessDeniedHandler,
AuthenticationEntryPoint {
    public void handle(HttpServletRequest request, HttpServletResponse response, AccessDeniedException e) throws IOException {
        this.doHandler(response, (Exception)e);
    }

    public void commence(HttpServletRequest request, HttpServletResponse response, AuthenticationException e) throws IOException {
        this.doHandler(response, (Exception)e);
    }

    private void doHandler(HttpServletResponse response, Exception e) throws IOException {
        response.setContentType("application/json;charset=UTF-8");
        PrintWriter out = response.getWriter();
        ErrorResponse result = e instanceof AccessDeniedException ? ErrorResponse.error((ResponseCode)ResponseCode.BIZ_NO_PRIVILEGE, (Throwable)e) : (e instanceof InsufficientAuthenticationException ? ErrorResponse.error((ResponseCode)ResponseCode.BIZ_NO_LOGIN, (Throwable)e) : (e instanceof AccountExpiredException ? ErrorResponse.error((ResponseCode)ResponseCode.BIZ_NO_LOGIN_EXPIRE, (Throwable)e) : ErrorResponse.error((ResponseCode)ResponseCode.BIZ_NO_LOGIN_OR_EXPIRE, (Throwable)e)));
        out.write(JsonUtil.object2Json((Object)result));
        out.flush();
    }
}

