/*
 * Decompiled with CFR 0.152.
 */
package cn.slipi.admin.common.interceptor;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.SecureUtil;
import cn.slipi.admin.common.annotation.CheckRepeat;
import cn.slipi.admin.common.enums.ResponseCode;
import cn.slipi.admin.common.exception.BizException;
import cn.slipi.admin.common.util.cache.JedisClusterUtil;
import java.lang.reflect.Method;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;

@Component
public class CheckRepeatInterceptor
implements HandlerInterceptor {
    @Autowired
    private JedisClusterUtil jedisClusterUtil;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
        Method m;
        HandlerMethod handlerMethod;
        Class clz;
        if (handler instanceof HandlerMethod && this.needCheckRepeat(clz = (handlerMethod = (HandlerMethod)handler).getBeanType(), m = handlerMethod.getMethod())) {
            if (this.checkRepeat(request)) {
                return true;
            }
            throw new BizException(ResponseCode.SYSTEM_REPEAT_ERROR);
        }
        return true;
    }

    private boolean checkRepeat(HttpServletRequest request) {
        String repeatKey = SecureUtil.md5((String)String.format("%s-%s-%s", request.getRequestedSessionId(), request.getHeader("Authorization"), request.getRequestURI()));
        if (StrUtil.isEmpty((CharSequence)this.jedisClusterUtil.get(repeatKey))) {
            this.jedisClusterUtil.set(repeatKey, DateUtil.now(), 20);
            return true;
        }
        return false;
    }

    private boolean needCheckRepeat(Class<?> clz, Method m) {
        return clz.isAnnotationPresent(CheckRepeat.class) || m.isAnnotationPresent(CheckRepeat.class);
    }
}

