/*
 * Decompiled with CFR 0.152.
 */
package cn.slipi.admin.common.interceptor;

import cn.slipi.admin.common.interceptor.LogBuilder;
import cn.slipi.admin.common.util.DateUtil;
import cn.slipi.admin.common.util.UserAgentGetter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

@Component
public class GateInterceptor
implements HandlerInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger((String)"gateLogger");
    private static final String REQUEST_START_TIME_ATTRIBUTE_KEY = "request_start";

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
        Long start = System.currentTimeMillis();
        request.setAttribute(REQUEST_START_TIME_ATTRIBUTE_KEY, (Object)start);
        return true;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, @Nullable ModelAndView modelAndView) {
        Long end = System.currentTimeMillis();
        Long start = (Long)request.getAttribute(REQUEST_START_TIME_ATTRIBUTE_KEY);
        String method = request.getMethod();
        String uri = request.getServletPath();
        long duration = end - start;
        LogBuilder node = LogBuilder.builder().put("action_time", (Object)System.currentTimeMillis()).put("url", (Object)(method + uri)).put("ip", (Object)UserAgentGetter.getIp((HttpServletRequest)request)).put("duration", (Object)DateUtil.formatMilliSecond((long)duration)).put("status", (Object)response.getStatus());
        LOG.info(node.build());
    }
}

