/*
 * Decompiled with CFR 0.152.
 */
package cn.slipi.admin.common.interceptor;

import cn.hutool.core.date.DateTime;
import cn.slipi.admin.common.interceptor.MybatisSqlInterceptor;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.type.TypeHandlerRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
@Intercepts(value={@Signature(type=Executor.class, method="update", args={MappedStatement.class, Object.class}), @Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class})})
public class MybatisSqlInterceptor
implements Interceptor {
    private static final Logger logger = LoggerFactory.getLogger(MybatisSqlInterceptor.class);

    public Object intercept(Invocation invocation) throws Throwable {
        MappedStatement mappedStatement = (MappedStatement)invocation.getArgs()[0];
        Object parameter = null;
        if (invocation.getArgs().length > 1) {
            parameter = invocation.getArgs()[1];
        }
        String sqlId = mappedStatement.getId();
        BoundSql boundSql = mappedStatement.getBoundSql(parameter);
        Configuration configuration = mappedStatement.getConfiguration();
        long start = System.currentTimeMillis();
        Object returnValue = invocation.proceed();
        long end = System.currentTimeMillis();
        long time = end - start;
        if (time > 1L) {
            String sql = MybatisSqlInterceptor.getSql((Configuration)configuration, (BoundSql)boundSql, (String)sqlId, (long)time);
            logger.info("{}", (Object)sql);
        }
        return returnValue;
    }

    public static String getSql(Configuration configuration, BoundSql boundSql, String sqlId, long time) {
        String sql = MybatisSqlInterceptor.showSql((Configuration)configuration, (BoundSql)boundSql);
        return String.format("%s %s [%s;] cost %s ms", MybatisSqlInterceptor.date2str((Date)new Date(), (DatePatternEnum)DatePatternEnum.yyyyMMddHHmmssSSS), sqlId, sql, time);
    }

    private static String getParameterValue(Object obj) {
        String value;
        if (obj instanceof String) {
            if (((String)obj).contains("$")) {
                return "''";
            }
            value = "'" + obj + "'";
        } else {
            value = obj instanceof Date ? "'" + MybatisSqlInterceptor.date2str((Date)((Date)obj), (DatePatternEnum)DatePatternEnum.yyyyMMddHHmmss) + "'" : (obj != null ? obj.toString() : "");
        }
        return value;
    }

    public static String showSql(Configuration configuration, BoundSql boundSql) {
        Object parameterObject = boundSql.getParameterObject();
        List parameterMappings = boundSql.getParameterMappings();
        String sql = boundSql.getSql().replaceAll("[\\s]+", " ");
        if (parameterMappings.size() > 0 && parameterObject != null) {
            TypeHandlerRegistry typeHandlerRegistry = configuration.getTypeHandlerRegistry();
            if (typeHandlerRegistry.hasTypeHandler(parameterObject.getClass())) {
                sql = sql.replaceFirst("\\?", MybatisSqlInterceptor.getParameterValue((Object)parameterObject));
            } else {
                MetaObject metaObject = configuration.newMetaObject(parameterObject);
                for (ParameterMapping parameterMapping : parameterMappings) {
                    Object obj;
                    String propertyName = parameterMapping.getProperty();
                    if (metaObject.hasGetter(propertyName)) {
                        obj = metaObject.getValue(propertyName);
                        sql = sql.replaceFirst("\\?", MybatisSqlInterceptor.getParameterValue((Object)obj));
                        continue;
                    }
                    if (!boundSql.hasAdditionalParameter(propertyName)) continue;
                    obj = boundSql.getAdditionalParameter(propertyName);
                    sql = sql.replaceFirst("\\?", MybatisSqlInterceptor.getParameterValue((Object)obj));
                }
            }
        }
        return sql;
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
    }

    private static String date2str(Date date, DatePatternEnum pattern) {
        return new DateTime(date).toString(pattern.getPattern());
    }
}

