/*
 * Decompiled with CFR 0.152.
 */
package cn.slipi.admin.common.interceptor;

import cn.hutool.crypto.SecureUtil;
import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONObject;
import cn.slipi.admin.common.annotation.Sign;
import cn.slipi.admin.common.enums.ResponseCode;
import cn.slipi.admin.common.exception.BizException;
import cn.slipi.admin.common.servlet.RequestWrapper;
import cn.slipi.admin.common.util.ServletUtil;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;

@Component
public class SignVerifyInterceptor
implements HandlerInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(SignVerifyInterceptor.class);
    private static final long TIMEOUT = 60000L;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        Method m;
        HandlerMethod handlerMethod;
        Class clazz;
        if (handler instanceof HandlerMethod && this.needSign(clazz = (handlerMethod = (HandlerMethod)handler).getBeanType(), m = handlerMethod.getMethod()) && !this.verifySign(request)) {
            throw new BizException(ResponseCode.BIZ_SIGN_ERROR);
        }
        return true;
    }

    private boolean verifySign(HttpServletRequest request) throws IOException {
        String token = request.getHeader("Authorization");
        String timestamp = request.getHeader("timestamp");
        String sign = request.getHeader("sign");
        if (StringUtils.isEmpty((CharSequence)timestamp) || StringUtils.isEmpty((CharSequence)sign)) {
            LOG.warn("\u9a8c\u7b7e->[\u65f6\u95f4\u6233\u4e3a\u7a7a]");
            return false;
        }
        if (System.currentTimeMillis() - Long.parseLong(timestamp) > 60000L) {
            LOG.warn("\u9a8c\u7b7e->[\u8bf7\u6c42\u8d85\u65f6\uff1a{}]", (Object)timestamp);
            return false;
        }
        RequestWrapper requestWrapper = new RequestWrapper(request);
        TreeMap dealParams = new TreeMap();
        SortedMap bodyParams = ServletUtil.getBodyParams((HttpServletRequest)requestWrapper);
        bodyParams.forEach((key, value) -> {
            if (!(value instanceof JSONArray) && !(value instanceof JSONObject)) {
                dealParams.put(key, value.toString().replace(" ", ""));
            } else {
                dealParams.put(key, value);
            }
        });
        String curSign = this.sign(token, timestamp, dealParams);
        LOG.info("\u9a8c\u7b7e{}->[\u524d\u7aeftimestamp:{}, \u524d\u7aefsign:{}, \u540e\u7aefsign:{}]", new Object[]{request.getRequestURI(), timestamp, sign, curSign});
        return sign.equals(curSign);
    }

    private String sign(String token, String timestamp, SortedMap<String, Object> params) {
        StringBuilder paramValues = new StringBuilder();
        paramValues.append(timestamp).append(token);
        params.forEach((key, value) -> paramValues.append((String)key).append(value));
        LOG.info("signStr:{}", (Object)paramValues.toString());
        return SecureUtil.md5((String)paramValues.toString());
    }

    private boolean needSign(Class<?> clazz, Method m) {
        return clazz.isAnnotationPresent(Sign.class) || m.isAnnotationPresent(Sign.class);
    }
}

