/*
 * Decompiled with CFR 0.152.
 */
package cn.slipi.admin.common.page;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.OrderItem;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class PageParam<T>
extends Page<T> {
    private static final Logger log = LoggerFactory.getLogger(PageParam.class);
    private static final String FILED_PAGE = "page";
    private static final String FILED_LIMIT = "limit";
    private static final String FILED_SORT = "sort";
    private static final String FILED_ORDER = "order";
    private static final String VALUE_ORDER_ASC = "asc";
    private static final String VALUE_ORDER_DESC = "desc";
    private static final Pattern HUMP_PATTERN = Pattern.compile("[A-Z]");
    private Map<String, Object> pageData;
    private boolean needToLine = true;

    public PageParam() {
    }

    public PageParam(Object obj) {
        this.init(obj);
    }

    public PageParam(HttpServletRequest request) {
        this.init(request);
    }

    public PageParam(HttpServletRequest request, boolean needToLine) {
        this.setNeedToLine(needToLine);
        this.init(request);
    }

    public boolean isNeedToLine() {
        return this.needToLine;
    }

    public PageParam<T> setNeedToLine(boolean needToLine) {
        this.needToLine = needToLine;
        return this;
    }

    public Map<String, Object> getPageData() {
        return this.pageData;
    }

    public void setPageData(Map<String, Object> data) {
        this.pageData = data;
    }

    public PageParam<T> init(Object o) {
        String[] fields;
        String sortValue = null;
        String orderValue = null;
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (String name : fields = this.getFieldName(o)) {
            String value;
            Object objValue = this.getFieldValueByName(name, o);
            if (objValue == null || StrUtil.isEmpty((CharSequence)(value = objValue.toString()).replace(" ", ""))) continue;
            if ("page".equals(name)) {
                this.setCurrent(Long.parseLong(value));
                continue;
            }
            if ("limit".equals(name)) {
                this.setSize(Long.parseLong(value));
                continue;
            }
            if ("sort".equals(name)) {
                sortValue = this.needToLine ? PageParam.humpToLine((String)value) : value;
                continue;
            }
            if ("order".equals(name)) {
                orderValue = value;
                continue;
            }
            if ("createTimeStart".equals(name) || "createTimeEnd".equals(name)) {
                map.put(name, this.timeStrToTimestamp(value));
                continue;
            }
            map.put(name, value);
        }
        this.setPageData(map);
        if (sortValue != null) {
            this.setOrder(sortValue, !"desc".equals(orderValue));
        }
        return this;
    }

    private String[] getFieldName(Object o) {
        Field[] fields = o.getClass().getDeclaredFields();
        String[] fieldNames = new String[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            fieldNames[i] = fields[i].getName();
        }
        return fieldNames;
    }

    private Object getFieldValueByName(String fieldName, Object o) {
        try {
            String firstLetter = fieldName.substring(0, 1).toUpperCase();
            String getter = "get" + firstLetter + fieldName.substring(1);
            Method method = o.getClass().getMethod(getter, new Class[0]);
            return method.invoke(o, new Object[0]);
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u5c5e\u6027\u503c\u5931\u8d25\uff01" + e, (Throwable)e);
            return null;
        }
    }

    public PageParam<T> init(HttpServletRequest request) {
        String sortValue = null;
        String orderValue = null;
        HashMap<String, Object> map = new HashMap<String, Object>();
        Enumeration names = request.getParameterNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            String value = request.getParameter(name);
            if (value == null || value.isEmpty() || value.replace(" ", "").isEmpty()) continue;
            if ("page".equals(name)) {
                this.setCurrent(Long.parseLong(value));
                continue;
            }
            if ("limit".equals(name)) {
                this.setSize(Long.parseLong(value));
                continue;
            }
            if ("sort".equals(name)) {
                sortValue = this.needToLine ? PageParam.humpToLine((String)value) : value;
                continue;
            }
            if ("order".equals(name)) {
                orderValue = value;
                continue;
            }
            if ("createTimeStart".equals(name) || "createTimeEnd".equals(name)) {
                map.put(name, this.timeStrToTimestamp(value));
                continue;
            }
            map.put(name, value);
        }
        this.setPageData(map);
        if (sortValue != null) {
            this.setOrder(sortValue, !"desc".equals(orderValue));
        }
        return this;
    }

    public List<String> getOrderAscs() {
        ArrayList<String> ascs = new ArrayList<String>();
        List orders = this.getOrders();
        if (orders != null) {
            for (OrderItem order : orders) {
                if (!order.isAsc()) continue;
                ascs.add(order.getColumn());
            }
        }
        return ascs;
    }

    public List<String> getOrderDescs() {
        ArrayList<String> descs = new ArrayList<String>();
        List orders = this.getOrders();
        if (orders != null) {
            for (OrderItem order : orders) {
                if (order.isAsc()) continue;
                descs.add(order.getColumn());
            }
        }
        return descs;
    }

    public PageParam<T> addOrderAsc(String ... ascs) {
        if (ascs != null) {
            List tAscs = this.getOrderAscs();
            ArrayList<OrderItem> orderItems = new ArrayList<OrderItem>();
            for (String column : ascs) {
                if (tAscs.contains(column)) continue;
                OrderItem orderItem = new OrderItem();
                orderItem.setAsc(true);
                orderItem.setColumn(column);
                orderItems.add(orderItem);
            }
            if (this.getOrders() == null) {
                this.setOrders(orderItems);
            } else {
                this.getOrders().addAll(orderItems);
            }
        }
        return this;
    }

    public PageParam<T> addOrderDesc(String ... descs) {
        if (descs != null) {
            List tDescs = this.getOrderDescs();
            ArrayList<OrderItem> orderItems = new ArrayList<OrderItem>();
            for (String column : descs) {
                if (tDescs.contains(column)) continue;
                OrderItem orderItem = new OrderItem();
                orderItem.setAsc(false);
                orderItem.setColumn(column);
                orderItems.add(orderItem);
            }
            if (this.getOrders() == null) {
                this.setOrders(orderItems);
            } else {
                this.getOrders().addAll(orderItems);
            }
        }
        return this;
    }

    public PageParam<T> removeOrder(String order, Boolean isAsc) {
        List orderItems = this.getOrders();
        if (orderItems != null) {
            Iterator iterator = orderItems.iterator();
            while (iterator.hasNext()) {
                OrderItem item = (OrderItem)iterator.next();
                if (isAsc != null && isAsc.booleanValue() != item.isAsc() || !order.equals(item.getColumn())) continue;
                iterator.remove();
            }
        }
        return this;
    }

    public PageParam<T> setOrder(String order, boolean isAsc) {
        ArrayList<OrderItem> orderItems = new ArrayList<OrderItem>();
        if (order != null) {
            OrderItem orderItem = new OrderItem();
            orderItem.setAsc(isAsc);
            orderItem.setColumn(order);
            orderItems.add(orderItem);
        }
        this.setOrders(orderItems);
        return this;
    }

    public PageParam<T> setDefaultOrder(String[] ascs, String[] descs) {
        List orderItems = this.getOrders();
        if (orderItems == null || orderItems.size() == 0) {
            this.addOrderAsc(ascs);
            this.addOrderDesc(descs);
        }
        return this;
    }

    public PageParam<T> put(String key, Object value) {
        if (this.pageData == null) {
            this.pageData = new HashMap();
        }
        this.pageData.put(key, value);
        return this;
    }

    public Object get(String key) {
        return this.pageData.get(key);
    }

    public String getString(String key) {
        Object o = this.pageData.get(key);
        if (o != null) {
            return String.valueOf(o);
        }
        return null;
    }

    public Integer getInt(String key) {
        String str = this.getString(key);
        if (str != null) {
            return Integer.parseInt(str);
        }
        return null;
    }

    public Long getLong(String key) {
        String str = this.getString(key);
        if (str != null) {
            return Long.parseLong(str);
        }
        return null;
    }

    public Float getFloat(String key) {
        String str = this.getString(key);
        if (str != null) {
            return Float.valueOf(Float.parseFloat(str));
        }
        return null;
    }

    public Double getDouble(String key) {
        String str = this.getString(key);
        if (str != null) {
            return Double.parseDouble(str);
        }
        return null;
    }

    public Boolean getBoolean(String key) {
        String str = this.getString(key);
        if (str != null) {
            return Boolean.parseBoolean(str);
        }
        return null;
    }

    public QueryWrapper<T> getWrapper(String ... excludes) {
        List<String> exList = Arrays.asList(excludes);
        QueryWrapper queryWrapper = new QueryWrapper();
        for (String key : this.pageData.keySet()) {
            if (exList.contains(key)) continue;
            this.buildWrapper(queryWrapper, key, this.getString(key));
        }
        return queryWrapper;
    }

    public QueryWrapper<T> getWrapperWith(String ... columns) {
        List<String> keyList = Arrays.asList(columns);
        QueryWrapper queryWrapper = new QueryWrapper();
        for (String key : this.pageData.keySet()) {
            if (!keyList.contains(key)) continue;
            this.buildWrapper(queryWrapper, key, this.getString(key));
        }
        return queryWrapper;
    }

    private void buildWrapper(QueryWrapper<T> queryWrapper, String key, String value) {
        if (value == null || "deleted".equals(key)) {
            return;
        }
        if (Arrays.asList("id", "sortNumber", "state").contains(key) || key.endsWith("Id")) {
            queryWrapper.eq((Object)(this.needToLine ? PageParam.humpToLine((String)key) : key), (Object)value);
        } else if ("createTimeStart".equals(key)) {
            queryWrapper.ge((Object)"create_time", (Object)this.timeStrToTimestamp(value));
        } else if ("createTimeEnd".equals(key)) {
            queryWrapper.le((Object)"create_time", (Object)this.timeStrToTimestamp(value));
        } else {
            queryWrapper.like((Object)(this.needToLine ? PageParam.humpToLine((String)key) : key), (Object)value);
        }
    }

    private Long timeStrToTimestamp(String time) {
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(time, new ParsePosition(0)).getTime();
    }

    public QueryWrapper<T> getOrderWrapper(QueryWrapper<T> queryWrapper) {
        if (queryWrapper == null) {
            queryWrapper = new QueryWrapper();
        }
        queryWrapper.orderByAsc((Object[])this.getOrderAscs().toArray(new String[0]));
        queryWrapper.orderByDesc((Object[])this.getOrderDescs().toArray(new String[0]));
        return queryWrapper;
    }

    public QueryWrapper<T> getOrderWrapper() {
        return this.getOrderWrapper(this.getWrapper(new String[0]));
    }

    public Map<String, Object> getNoPageParam() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("pageData", this.pageData);
        List orders = this.getOrders();
        if (orders != null && orders.size() > 0) {
            map.put("orders", orders);
        }
        return map;
    }

    public T getOne(List<T> records) {
        return records == null || records.size() == 0 ? null : (T)records.get(0);
    }

    public List<T> sortRecords(List<T> records) {
        if (records == null || records.size() <= 1) {
            return records;
        }
        List orderItems = this.getOrders();
        if (orderItems != null) {
            Comparator<Object> comparator = null;
            for (OrderItem order : orderItems) {
                if (order.getColumn() == null) continue;
                Function<Object, Object> keyExtractor = t -> PageParam.getFieldValue((Object)t, (String)(this.needToLine ? PageParam.lineToHump((String)order.getColumn()) : order.getColumn()));
                if (comparator == null) {
                    if (order.isAsc()) {
                        comparator = Comparator.comparing(keyExtractor);
                        continue;
                    }
                    comparator = Comparator.comparing(keyExtractor, Comparator.reverseOrder());
                    continue;
                }
                if (order.isAsc()) {
                    comparator.thenComparing(keyExtractor);
                    continue;
                }
                comparator.thenComparing(keyExtractor, Comparator.reverseOrder());
            }
            if (comparator != null) {
                return records.stream().sorted(comparator).collect(Collectors.toList());
            }
        }
        return records;
    }

    public static String humpToLine(String str) {
        if (str == null) {
            return null;
        }
        Matcher matcher = HUMP_PATTERN.matcher(str);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(sb, "_" + matcher.group(0).toLowerCase());
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public static String lineToHump(String str) {
        if (str == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        String[] ss = str.split("_");
        sb.append(ss[0]);
        for (int i = 1; i < ss.length; ++i) {
            if (ss[i].length() > 0) {
                sb.append(ss[i].substring(0, 1).toUpperCase());
            }
            if (ss[i].length() <= 1) continue;
            sb.append(ss[i].substring(1));
        }
        return sb.toString();
    }

    public static Object getFieldValue(Object t, String field) {
        if (t == null || field == null) {
            return null;
        }
        try {
            Field clazzField = t.getClass().getDeclaredField(field);
            clazzField.setAccessible(true);
            return clazzField.get(t);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

