/*
 * Decompiled with CFR 0.152.
 */
package cn.slipi.admin.common.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class DateUtil {
    private static final Integer PRE_MS = 1000;
    private static final String FORMAT_DATE = "yyyy.MM.dd";
    private static final String FORMAT_DATE_TIME = "yyyy.MM.dd HH:mm:ss";
    private static final String FORMAT_TIME = "HH:mm:ss";
    private static final String FORMAT_SORT_TIME = "HH:mm";

    public static Integer getTimeBySecond(Date date) {
        if (null == date) {
            return 0;
        }
        String timestamp = String.valueOf(date.getTime());
        int length = timestamp.length();
        if (length > 3) {
            return Integer.valueOf(timestamp.substring(0, length - 3));
        }
        return 0;
    }

    public static Long getTimeByMinSecond() {
        return System.currentTimeMillis();
    }

    public static Long dayStartStamp() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTimeInMillis();
    }

    public static Long dayEndStamp() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
        return calendar.getTimeInMillis();
    }

    public static Long preDayStartStamp(Integer x) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(calendar.get(1), calendar.get(2), calendar.get(5) - x, 0, 0, 0);
        calendar.set(14, 0);
        return calendar.getTime().getTime();
    }

    public static Long preDayEndStamp(Integer x) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(calendar.get(1), calendar.get(2), calendar.get(5) - x, 23, 59, 59);
        calendar.set(14, 999);
        return calendar.getTime().getTime();
    }

    public static Long dateToTimeStamp(String dateStr, String format) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(format);
            return sdf.parse(dateStr).getTime() / (long)PRE_MS.intValue();
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0L;
        }
    }

    public static String getGWT(int yearAmount) {
        Calendar cd = Calendar.getInstance();
        cd.add(1, yearAmount);
        SimpleDateFormat sdf = new SimpleDateFormat("EEE d MMM yyyy HH:mm:ss 'GMT'", Locale.US);
        sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
        return sdf.format(cd.getTime());
    }

    public static String getFormatDate(Date date) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(FORMAT_DATE_TIME);
        return simpleDateFormat.format(date);
    }

    public static Date getPreMonth(Integer num) {
        Calendar c = Calendar.getInstance();
        c.setTime(new Date());
        c.add(2, -num.intValue());
        return c.getTime();
    }

    public static String formatMilliSecond(long ms) {
        if (ms <= (long)PRE_MS.intValue()) {
            return ms + "ms";
        }
        if (ms % (long)PRE_MS.intValue() == 0L) {
            return String.format("%ss", ms / (long)PRE_MS.intValue());
        }
        double ds = (double)ms / (double)PRE_MS.intValue();
        return String.format("%.3fs", ds);
    }

    public static Long strToTimestamp(String date, String format) {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        try {
            return sdf.parse(date).getTime();
        }
        catch (ParseException e) {
            e.printStackTrace();
            return 0L;
        }
    }

    public static String dateFormatToString(Date date, String format) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
        return dateFormat.format(date);
    }
}

