/*
 * Decompiled with CFR 0.152.
 */
package cn.slipi.admin.common.util;

import cn.hutool.core.img.ImgUtil;
import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.io.IoUtil;
import cn.slipi.admin.common.util.JChardetFacadeUtil;
import cn.slipi.admin.common.util.OpenOfficeUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.tika.Tika;
import org.springframework.web.multipart.MultipartFile;

/*
 * Exception performing whole class analysis ignored.
 */
public class FileServerUtil {
    private static final List<String> SET_CHARSET_CONTENT_TYPES = Arrays.asList("application/json", "application/javascript");

    public static File upload(MultipartFile file, String directory, boolean uuidName) throws IOException, IllegalStateException {
        File outFile = FileServerUtil.getUploadFile((String)file.getOriginalFilename(), (String)directory, (boolean)uuidName);
        if (!outFile.getParentFile().exists() && !outFile.getParentFile().mkdirs()) {
            throw new RuntimeException("make directory fail");
        }
        file.transferTo(outFile);
        return outFile;
    }

    public static File upload(String base64, String fileName, String directory) throws FileNotFoundException, IORuntimeException {
        if (base64 == null || base64.trim().isEmpty()) {
            throw new RuntimeException("base64 is empty");
        }
        String suffix = base64.substring(11, base64.indexOf(";"));
        File outFile = FileServerUtil.getUploadFile((String)suffix, (String)directory, (fileName == null || fileName.trim().isEmpty() ? 1 : 0) != 0);
        byte[] bytes = Base64.getDecoder().decode(base64.substring(base64.indexOf(";") + 8).getBytes());
        IoUtil.write((OutputStream)new FileOutputStream(outFile), (boolean)true, (byte[])bytes);
        return outFile;
    }

    public static File getUploadFile(String fileName, String directory, boolean uuidName) {
        File file;
        String suffix;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd/");
        String dir = sdf.format(new Date());
        if (fileName == null) {
            uuidName = true;
            suffix = "";
        } else {
            suffix = fileName.substring(fileName.lastIndexOf("."));
        }
        if (uuidName) {
            String uuid = UUID.randomUUID().toString().replaceAll("-", "");
            file = new File(directory, dir + uuid + suffix);
        } else {
            file = new File(directory, dir + fileName);
            String prefix = fileName.substring(0, fileName.lastIndexOf("."));
            int sameSize = 2;
            while (file.exists()) {
                file = new File(directory, dir + prefix + "(" + sameSize + ")" + suffix);
                ++sameSize;
            }
        }
        return file;
    }

    public static void preview(File file, String pdfDir, String officeHome, HttpServletResponse response, HttpServletRequest request) {
        FileServerUtil.preview((File)file, (boolean)false, (String)pdfDir, (String)officeHome, (HttpServletResponse)response, (HttpServletRequest)request);
    }

    public static void preview(File file, boolean forceDownload, String pdfDir, String officeHome, HttpServletResponse response, HttpServletRequest request) {
        FileServerUtil.cross((HttpServletResponse)response);
        if (file == null || !file.exists()) {
            FileServerUtil.outNotFund((HttpServletResponse)response);
            return;
        }
        if (forceDownload) {
            FileServerUtil.setDownloadHeader((HttpServletResponse)response, (String)file.getName());
        } else {
            String contentType;
            File pdfFile;
            if (OpenOfficeUtil.canConverter((String)file.getName()) && (pdfFile = OpenOfficeUtil.converterToPDF((String)file.getAbsolutePath(), (String)pdfDir, (String)officeHome)) != null) {
                file = pdfFile;
            }
            if ((contentType = FileServerUtil.getContentType((File)file)) != null) {
                if (contentType.startsWith("text/") || SET_CHARSET_CONTENT_TYPES.contains(contentType)) {
                    try {
                        String charset = JChardetFacadeUtil.detectCodepage((URL)file.toURI().toURL());
                        if (charset != null) {
                            response.setCharacterEncoding(charset);
                        }
                    }
                    catch (MalformedURLException e) {
                        e.printStackTrace();
                    }
                }
                response.setContentType(contentType);
                response.setHeader("Cache-Control", "public");
            } else {
                FileServerUtil.setDownloadHeader((HttpServletResponse)response, (String)file.getName());
            }
        }
        FileServerUtil.output((File)file, (HttpServletResponse)response, (HttpServletRequest)request);
    }

    public static void previewThumbnail(File file, File thumbnail, Integer size, String officeHome, HttpServletResponse response, HttpServletRequest request) {
        if (!thumbnail.exists() && FileServerUtil.isImage((File)file)) {
            long fileSize = file.length();
            if (fileSize / 1024L > (long)size.intValue()) {
                try {
                    if (thumbnail.getParentFile().mkdirs()) {
                        ImgUtil.scale((File)file, (File)thumbnail, (float)(100.0f / ((float)fileSize / 1024.0f)));
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                FileServerUtil.preview((File)file, null, (String)officeHome, (HttpServletResponse)response, (HttpServletRequest)request);
                return;
            }
        }
        FileServerUtil.preview((File)thumbnail, null, (String)officeHome, (HttpServletResponse)response, (HttpServletRequest)request);
    }

    public static void output(File file, HttpServletResponse response, HttpServletRequest request) {
        long length = file.length();
        long start = 0L;
        long to = length - 1L;
        long lastModified = file.lastModified();
        response.setHeader("Accept-Ranges", "bytes");
        response.setHeader("ETag", "\"" + length + "-" + lastModified + "\"");
        response.setHeader("Last-Modified", new Date(lastModified).toString());
        String range = request.getHeader("Range");
        if (range != null) {
            response.setStatus(206);
            String[] ranges = range.replace("bytes=", "").split("-");
            start = Long.parseLong(ranges[0].trim());
            if (ranges.length > 1) {
                to = Long.parseLong(ranges[1].trim());
            }
            response.addHeader("Content-Range", "bytes " + start + "-" + to + "/" + length);
        }
        response.setHeader("Content-Length", String.valueOf(to - start + 1L));
        try {
            FileServerUtil.output((File)file, (OutputStream)response.getOutputStream(), (Integer)2048, (Long)start, (Long)to);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void output(File file, OutputStream os) {
        FileServerUtil.output((File)file, (OutputStream)os, null);
    }

    public static void output(File file, OutputStream os, Integer size) {
        FileServerUtil.output((File)file, (OutputStream)os, (Integer)size, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void output(File file, OutputStream os, Integer size, Long start, Long to) {
        BufferedInputStream is = null;
        try {
            is = new BufferedInputStream(new FileInputStream(file));
            if (start != null) {
                long skip = is.skip(start);
                if (skip < start) {
                    System.out.println("ERROR: skip fail: skipped=" + skip + ", start: " + start);
                }
                to = to - start + 1L;
            }
            byte[] bytes = new byte[size == null ? 2048 : size];
            if (to == null) {
                int len;
                while ((len = is.read(bytes)) != -1) {
                    os.write(bytes, 0, len);
                }
            } else {
                int len;
                while (to > 0L && (len = is.read(bytes)) != -1) {
                    os.write(bytes, 0, to < (long)len ? (int)to.longValue() : len);
                    to = to - (long)len;
                }
            }
            os.flush();
        }
        catch (IOException e) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException e) {}
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    System.out.println(e.getMessage());
                }
            }
        }
    }

    public static List<Map<String, Object>> list(File directory, String baseURL, String thumbnailURL) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        if (!directory.exists() || !directory.isDirectory()) {
            return list;
        }
        File[] files = directory.listFiles();
        if (files == null) {
            return list;
        }
        for (File f : files) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("name", f.getName());
            map.put("isDirectory", f.isDirectory());
            if (!f.isDirectory()) {
                map.put("length", f.length());
                map.put("url", baseURL + f.getName());
                if (FileServerUtil.isImage((File)f)) {
                    map.put("thumbnail", thumbnailURL + f.getName());
                }
            } else {
                map.put("length", 0L);
            }
            map.put("updateTime", f.lastModified());
            list.add(map);
        }
        return list;
    }

    public static String getContentType(File file) {
        String contentType = null;
        try {
            contentType = new Tika().detect(file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return contentType;
    }

    public static boolean isImage(File file) {
        String contentType = FileServerUtil.getContentType((File)file);
        return contentType != null && contentType.startsWith("image/");
    }

    public static void setDownloadHeader(HttpServletResponse response, String fileName) {
        response.setContentType("application/force-download");
        try {
            fileName = URLEncoder.encode(fileName, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        response.setHeader("Content-Disposition", "attachment;fileName=" + fileName);
    }

    public static void outNotFund(HttpServletResponse response) {
        response.setStatus(404);
        FileServerUtil.outMessage((String)"404 Not Found", null, (HttpServletResponse)response);
    }

    public static void outMessage(String title, String message, HttpServletResponse response) {
        response.setContentType("text/html;charset=UTF-8");
        try {
            PrintWriter writer = response.getWriter();
            writer.write("<!doctype html>");
            writer.write("<title>" + title + "</title>");
            writer.write("<h1 style=\"text-align: center\">" + title + "</h1>");
            if (message != null) {
                writer.write(message);
            }
            writer.write("<hr/><p style=\"text-align: center\">Easy File Server</p>");
            writer.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void cross(HttpServletResponse response) {
        response.setHeader("Access-Control-Allow-Origin", "*");
        response.setHeader("Access-Control-Allow-Methods", "GET, POST, PUT, DELETE, OPTIONS");
        response.setHeader("Access-Control-Max-Age", "3600");
        response.setHeader("Access-Control-Allow-Headers", "Content-Type, x-requested-with, X-Custom-Header, Authorization");
    }
}

