/*
 * Decompiled with CFR 0.152.
 */
package cn.slipi.admin.common.util;

import java.io.File;
import java.util.Arrays;
import java.util.Base64;
import org.artofsolving.jodconverter.OfficeDocumentConverter;
import org.artofsolving.jodconverter.office.DefaultOfficeManagerConfiguration;
import org.artofsolving.jodconverter.office.OfficeManager;

/*
 * Exception performing whole class analysis ignored.
 */
public class OpenOfficeUtil {
    private static final String[] CAN_CONVERTER_FILES = new String[]{"doc", "docx", "xls", "xlsx", "ppt", "pptx"};

    public static File converterToPDF(String filePath, String outDir, String officeHome) {
        return OpenOfficeUtil.converterToPDF((String)filePath, (String)outDir, (String)officeHome, (boolean)true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File converterToPDF(String filePath, String outDir, String officeHome, boolean cache) {
        if (filePath == null || filePath.trim().isEmpty()) {
            return null;
        }
        File srcFile = new File(filePath);
        if (!srcFile.exists()) {
            return null;
        }
        String outPath = Base64.getEncoder().encodeToString(filePath.getBytes()).replace("/", "-").replace("+", "-");
        File outFile = new File(outDir, outPath + ".pdf");
        if (cache && outFile.exists()) {
            return outFile;
        }
        OfficeManager officeManager = null;
        try {
            officeManager = OpenOfficeUtil.getOfficeManager((String)officeHome);
            OfficeDocumentConverter converter = new OfficeDocumentConverter(officeManager);
            File file = OpenOfficeUtil.converterFile((File)srcFile, (File)outFile, (OfficeDocumentConverter)converter);
            return file;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (officeManager != null) {
                officeManager.stop();
            }
        }
        return null;
    }

    public static File converterFile(File inFile, File outFile, OfficeDocumentConverter converter) {
        if (!outFile.getParentFile().exists() && !outFile.getParentFile().mkdirs()) {
            return outFile;
        }
        converter.convert(inFile, outFile);
        return outFile;
    }

    public static boolean canConverter(String path) {
        try {
            String suffix = path.substring(path.lastIndexOf(".") + 1);
            return Arrays.asList(CAN_CONVERTER_FILES).contains(suffix);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static OfficeManager getOfficeManager(String officeHome) {
        if (officeHome == null || officeHome.trim().isEmpty()) {
            return null;
        }
        DefaultOfficeManagerConfiguration config = new DefaultOfficeManagerConfiguration();
        config.setOfficeHome(officeHome);
        OfficeManager officeManager = config.buildOfficeManager();
        officeManager.start();
        return officeManager;
    }
}

