/*
 * Decompiled with CFR 0.152.
 */
package cn.slipi.admin.common.util.cache;

import cn.slipi.admin.common.aspect.UsedTimeAspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import redis.clients.jedis.JedisCluster;

@Component
public class JedisClusterUtil {
    private static final Logger logger = LoggerFactory.getLogger(UsedTimeAspect.class);
    @Autowired
    private JedisCluster jedisCluster;

    public boolean setNx(String key, String value, int expireTime) {
        try {
            Long setSuccess = this.jedisCluster.setnx(key, value);
            if (setSuccess == 1L) {
                if (1L == this.jedisCluster.expire(key, expireTime)) {
                    return true;
                }
                this.deleteKey(key);
                return false;
            }
            return false;
        }
        catch (Exception e) {
            try {
                this.deleteKey(key);
            }
            catch (Exception ex) {
                logger.error("\u5220\u9664key\u5f02\u5e38:key = " + key);
            }
            logger.error("jedis setNx error", (Throwable)e);
            return false;
        }
    }

    public boolean hSet(String key, String field, String value) {
        return this.jedisCluster.hset(key, field, value) > 0L;
    }

    public boolean hSetNx(String key, String field, String value) {
        return this.jedisCluster.hsetnx(key, field, value) > 0L;
    }

    public String hGet(String key, String field) {
        return this.jedisCluster.hget(key, field);
    }

    public boolean hDel(String key, String field) {
        return this.jedisCluster.hdel(key, new String[]{field}) > 0L;
    }

    public boolean set(String key, String value, int expireTime) {
        try {
            this.jedisCluster.setex(key, expireTime, value);
            return true;
        }
        catch (Exception e) {
            logger.error("jedis set error", (Throwable)e);
            return false;
        }
    }

    public void setForUp(String key, String value, int expireTime) {
        this.jedisCluster.setex(key, expireTime, value);
    }

    public String get(String key) {
        try {
            return this.jedisCluster.get(key);
        }
        catch (Exception e) {
            logger.error("jedis get error", (Throwable)e);
            return null;
        }
    }

    public boolean deleteKey(String key) {
        try {
            if (!this.isExist(key)) {
                return false;
            }
            return 1L == this.jedisCluster.del(key);
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean incr(String key) {
        try {
            this.jedisCluster.incr(key);
            return true;
        }
        catch (Exception e) {
            logger.error("jedis incr error", (Throwable)e);
            return false;
        }
    }

    public boolean decr(String key) {
        try {
            this.jedisCluster.decr(key);
            return true;
        }
        catch (Exception e) {
            logger.error("jedis decr error", (Throwable)e);
            return false;
        }
    }

    public boolean expire(String key, Integer seconds) {
        return this.jedisCluster.expire(key, seconds.intValue()) > 0L;
    }

    public boolean isExist(String key) throws Exception {
        try {
            return this.jedisCluster.exists(key);
        }
        catch (Exception e) {
            logger.error("{\u4e25\u91cd\u5f02\u5e38}\u5224\u65adkey\u662f\u5426\u5b58\u5728\u53d1\u751f\u5f02\u5e38... ... key = " + key, (Throwable)e);
            throw new Exception("{\u4e25\u91cd\u5f02\u5e38}\u5224\u65adkey\u662f\u5426\u5b58\u5728\u53d1\u751f\u5f02\u5e38... ...key = " + key);
        }
    }
}

