/*
 * Decompiled with CFR 0.152.
 */
package cn.slipi.admin.common.util.cache.lock;

import cn.slipi.admin.common.enums.ResponseCode;
import cn.slipi.admin.common.exception.BizException;
import cn.slipi.admin.common.util.cache.JedisClusterUtil;
import cn.slipi.admin.common.util.cache.lock.LockKey;
import java.util.Arrays;
import java.util.concurrent.ThreadLocalRandom;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RedisLock {
    private static final Logger log = LoggerFactory.getLogger(RedisLock.class);
    private static final int LOCK_TIMEOUT = 30000;
    private static final ThreadLocalRandom RANDOM = ThreadLocalRandom.current();
    @Autowired
    private JedisClusterUtil jedisClusterUtil;

    public void lock(LockKey lockKey) {
        if (lockKey == null) {
            throw new BizException(ResponseCode.BIZ_LOCK_ERROR);
        }
        String redisKey = this.getKey(lockKey.getPrefix(), lockKey.getElements());
        long startTime = System.currentTimeMillis();
        while (true) {
            if (this.jedisClusterUtil.setNx(redisKey, lockKey.getUuid(), 30000)) break;
            if (System.currentTimeMillis() - startTime > 30000L) {
                log.warn("+++ redisKey locked --> " + redisKey);
                throw new BizException(ResponseCode.BIZ_LOCK_TIMEOUT_ERROR);
            }
            try {
                Thread.sleep(50 + RANDOM.nextInt(50));
            }
            catch (InterruptedException e) {
                log.warn("+++ redis lock fail --> " + redisKey);
            }
        }
        log.info("+++ redisKey locked --> " + redisKey);
    }

    public void unLock(LockKey lockKey) {
        String value;
        String redisKey = this.getKey(lockKey.getPrefix(), lockKey.getElements());
        String uuid = lockKey.getUuid();
        if (uuid.equals(value = this.jedisClusterUtil.get(redisKey))) {
            if (this.jedisClusterUtil.deleteKey(redisKey)) {
                log.info("+++ redisKey unlocked --> " + redisKey);
            } else {
                log.warn("+++ redis unlock fail --> " + redisKey);
            }
        }
    }

    private String getKey(String keyPrefix, String[] keyElements) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(keyPrefix).append(":");
        Arrays.sort(keyElements);
        for (String keyElement : keyElements) {
            stringBuilder.append(keyElement);
        }
        return stringBuilder.toString();
    }
}

