/*
 * Decompiled with CFR 0.152.
 */
package cn.slipi.admin.common.util.dozer.impl;

import cn.slipi.admin.common.util.dozer.IGenerator;
import java.lang.ref.WeakReference;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.dozer.DozerBeanMapper;
import org.dozer.Mapper;
import org.dozer.loader.api.BeanMappingBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
@Lazy(value=true)
public class ConvertBean
implements IGenerator {
    @Autowired
    protected Mapper mapper;

    public <T, S> T convert(S s, Class<T> clz) {
        if (s == null) {
            return null;
        }
        return (T)this.mapper.map(s, clz);
    }

    public <T, S> List<T> convert(List<S> s, Class<T> clz) {
        if (s == null) {
            return null;
        }
        ArrayList<Object> list = new ArrayList<Object>();
        for (S vs : s) {
            list.add(this.mapper.map(vs, clz));
        }
        return list;
    }

    public <T, S> Set<T> convert(Set<S> s, Class<T> clz) {
        if (s == null) {
            return null;
        }
        HashSet<Object> set = new HashSet<Object>();
        for (S vs : s) {
            set.add(this.mapper.map(vs, clz));
        }
        return set;
    }

    public <T, S> T[] convert(S[] s, Class<T> clz) {
        if (s == null) {
            return null;
        }
        Object[] arr = (Object[])Array.newInstance(clz, s.length);
        for (int i = 0; i < s.length; ++i) {
            arr[i] = this.mapper.map(s[i], clz);
        }
        return arr;
    }

    public void convert(Object source, Object target) {
        this.mapper.map(source, target);
    }

    public void convertNotNull(Object sources, Object destination) {
        WeakReference<DozerBeanMapper> weakReference = new WeakReference<DozerBeanMapper>(new DozerBeanMapper());
        DozerBeanMapper mapper = (DozerBeanMapper)weakReference.get();
        mapper.addMapping((BeanMappingBuilder)new /* Unavailable Anonymous Inner Class!! */);
        mapper.map(sources, destination);
        mapper.destroy();
        weakReference.clear();
    }
}

