/*
 * Decompiled with CFR 0.152.
 */
package cn.slipi.admin.controller.client;

import cn.slipi.admin.common.config.AdminConfig;
import cn.slipi.monitor.core.common.response.Result;
import cn.slipi.monitor.core.model.RegistryParam;
import cn.slipi.monitor.core.sapi.AdminInterface;
import cn.slipi.monitor.core.util.GsonUtil;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"client"})
public class ClientController {
    @Resource
    private AdminInterface adminInterface;

    @RequestMapping(value={"/{uri}"})
    @ResponseBody
    public Result<String> api(HttpServletRequest request, @PathVariable(value="uri") String uri, @RequestBody(required=false) String data) {
        if (!"POST".equalsIgnoreCase(request.getMethod())) {
            return new Result(Result.ERROR_CODE.intValue(), "invalid request, http method not support.");
        }
        if (uri == null || uri.trim().length() == 0) {
            return new Result(Result.ERROR_CODE.intValue(), "invalid request, uri mapping cant be null.");
        }
        if (AdminConfig.getAdminConfig().getAccessToken() != null && AdminConfig.getAdminConfig().getAccessToken().trim().length() > 0 && !AdminConfig.getAdminConfig().getAccessToken().equals(request.getHeader("LT-MONITOR-ACCESS-TOKEN"))) {
            return new Result(Result.ERROR_CODE.intValue(), "access token is wrong.");
        }
        if ("registry".equals(uri)) {
            RegistryParam registryParam = (RegistryParam)GsonUtil.fromJson((String)data, RegistryParam.class);
            return this.adminInterface.registry(registryParam);
        }
        if ("registryRemove".equals(uri)) {
            RegistryParam registryParam = (RegistryParam)GsonUtil.fromJson((String)data, RegistryParam.class);
            return this.adminInterface.registryRemove(registryParam);
        }
        return new Result(Result.ERROR_CODE.intValue(), "invalid request, uri mapping(" + uri + ") not found.");
    }
}

