/*
 * Decompiled with CFR 0.152.
 */
package cn.slipi.admin.controller.monitor;

import cn.slipi.admin.biz.monitor.AppBiz;
import cn.slipi.admin.biz.monitor.vo.app.AddForm;
import cn.slipi.admin.biz.monitor.vo.app.AppVo;
import cn.slipi.admin.biz.monitor.vo.app.BindForm;
import cn.slipi.admin.common.annotation.ApiPageParam;
import cn.slipi.admin.common.annotation.OperationLog;
import cn.slipi.admin.common.page.PageParam;
import cn.slipi.admin.common.response.JsonResponse;
import cn.slipi.admin.common.response.PageResponse;
import cn.slipi.admin.controller.system.BaseController;
import cn.slipi.admin.service.monitor.entity.App;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Validated
@RestController
@RequestMapping(value={"/api/monitor/app"})
public class AppController
extends BaseController {
    @Autowired
    private AppBiz serverBiz;

    @PreAuthorize(value="hasAuthority('monitor:app:list')")
    @ApiPageParam
    @GetMapping(value={"/page"})
    public PageResponse<AppVo> page(HttpServletRequest request) {
        PageParam pageParam = new PageParam(request);
        return new PageResponse(this.serverBiz.page(pageParam), pageParam.getTotal());
    }

    @PreAuthorize(value="hasAuthority('monitor:app:notify')")
    @OperationLog(value="\u5e94\u7528\u7ba1\u7406", desc="\u4fee\u6539\u901a\u77e5\u72b6\u6001", result=true)
    @PutMapping(value={"/notify/{id}"})
    public JsonResponse updateNotify(@PathVariable(value="id") Integer id, Integer isNotify) {
        String notifyUser = this.serverBiz.updateNotify(id, isNotify, this.getLoginUser());
        return JsonResponse.ok().put("notifyUser", (Object)notifyUser);
    }

    @PreAuthorize(value="hasAuthority('monitor:app:save')")
    @OperationLog(value="\u5e94\u7528\u7ba1\u7406", desc="\u6dfb\u52a0", result=true)
    @PostMapping
    public JsonResponse add(@Validated @RequestBody AddForm form) {
        if (this.serverBiz.add(form)) {
            return JsonResponse.ok();
        }
        return JsonResponse.fail();
    }

    @PreAuthorize(value="hasAuthority('monitor:app:update')")
    @OperationLog(value="\u5e94\u7528\u7ba1\u7406", desc="\u4fee\u6539", result=true)
    @PutMapping
    public JsonResponse update(@RequestBody App app) {
        if (this.serverBiz.update(app)) {
            return JsonResponse.ok();
        }
        return JsonResponse.fail();
    }

    @PreAuthorize(value="hasAuthority('monitor:app:remove')")
    @OperationLog(value="\u5e94\u7528\u7ba1\u7406", desc="\u5220\u9664", result=true)
    @DeleteMapping(value={"/{id}"})
    public JsonResponse remove(@PathVariable(value="id") Integer id) {
        if (this.serverBiz.delete(this.getLoginUser(), id)) {
            return JsonResponse.ok();
        }
        return JsonResponse.fail();
    }

    @PreAuthorize(value="hasAuthority('monitor:app:remove')")
    @OperationLog(value="\u5e94\u7528\u7ba1\u7406", desc="\u6279\u91cf\u5220\u9664", result=true)
    @DeleteMapping(value={"/batch"})
    public JsonResponse deleteBatch(@RequestBody List<Integer> ids) {
        if (this.serverBiz.deleteBatch(this.getLoginUser(), ids)) {
            return JsonResponse.ok();
        }
        return JsonResponse.fail();
    }

    @PreAuthorize(value="hasAuthority('monitor:app:bind:info')")
    @OperationLog(value="\u5e94\u7528\u7ba1\u7406", desc="\u7ed1\u5b9a\u7684\u670d\u52a1\u5668\u5217\u8868", result=true)
    @GetMapping(value={"/bind/list/{id}"})
    public JsonResponse bindList(@PathVariable(value="id") Integer id) {
        return JsonResponse.ok().setData((Object)this.serverBiz.bindList(id));
    }

    @PreAuthorize(value="hasAuthority('monitor:app:bind')")
    @OperationLog(value="\u5e94\u7528\u7ba1\u7406", desc="\u5e94\u7528\u7ed1\u5b9a\u4fe1\u606f", result=true)
    @PostMapping(value={"/bind"})
    public JsonResponse bindList(@Validated @RequestBody BindForm form) {
        this.serverBiz.bind(form);
        return JsonResponse.ok();
    }
}

