/*
 * Decompiled with CFR 0.152.
 */
package cn.slipi.admin.controller.monitor;

import cn.slipi.admin.biz.monitor.ServerBiz;
import cn.slipi.admin.biz.monitor.vo.server.AddForm;
import cn.slipi.admin.biz.monitor.vo.server.ServerVo;
import cn.slipi.admin.common.annotation.ApiPageParam;
import cn.slipi.admin.common.annotation.OperationLog;
import cn.slipi.admin.common.page.PageParam;
import cn.slipi.admin.common.response.JsonResponse;
import cn.slipi.admin.common.response.PageResponse;
import cn.slipi.admin.controller.system.BaseController;
import cn.slipi.admin.service.monitor.entity.Server;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Validated
@RestController
@RequestMapping(value={"/api/monitor/server"})
public class ServerController
extends BaseController {
    @Autowired
    private ServerBiz serverBiz;

    @PreAuthorize(value="hasAuthority('monitor:server:list')")
    @ApiPageParam
    @GetMapping(value={"/page"})
    public PageResponse<ServerVo> page(HttpServletRequest request) {
        PageParam pageParam = new PageParam(request);
        return new PageResponse(this.serverBiz.page(pageParam), pageParam.getTotal());
    }

    @PreAuthorize(value="hasAuthority('monitor:server:save')")
    @OperationLog(value="\u670d\u52a1\u5668\u7ba1\u7406", desc="\u6dfb\u52a0", result=true)
    @PostMapping
    public JsonResponse add(@Validated @RequestBody AddForm form) {
        if (this.serverBiz.add(form)) {
            return JsonResponse.ok();
        }
        return JsonResponse.fail();
    }

    @PreAuthorize(value="hasAuthority('monitor:server:update')")
    @OperationLog(value="\u670d\u52a1\u5668\u7ba1\u7406", desc="\u4fee\u6539", result=true)
    @PutMapping
    public JsonResponse update(@RequestBody Server server) {
        if (this.serverBiz.update(server)) {
            return JsonResponse.ok();
        }
        return JsonResponse.fail();
    }

    @PreAuthorize(value="hasAuthority('monitor:server:remove')")
    @OperationLog(value="\u670d\u52a1\u5668\u7ba1\u7406", desc="\u5220\u9664", result=true)
    @DeleteMapping(value={"/{id}"})
    public JsonResponse remove(@PathVariable(value="id") Integer id) {
        if (this.serverBiz.delete(this.getLoginUser(), id)) {
            return JsonResponse.ok();
        }
        return JsonResponse.fail();
    }

    @PreAuthorize(value="hasAuthority('monitor:server:remove:batch')")
    @OperationLog(value="\u670d\u52a1\u5668\u7ba1\u7406", desc="\u6279\u91cf\u5220\u9664", result=true)
    @DeleteMapping(value={"/batch"})
    public JsonResponse deleteBatch(@RequestBody List<Integer> ids) {
        if (this.serverBiz.deleteBatch(this.getLoginUser(), ids)) {
            return JsonResponse.ok();
        }
        return JsonResponse.fail();
    }
}

