/*
 * Decompiled with CFR 0.152.
 */
package cn.slipi.admin.controller.system;

import cn.slipi.admin.biz.system.DictionaryBiz;
import cn.slipi.admin.common.annotation.ApiPageParam;
import cn.slipi.admin.common.page.PageParam;
import cn.slipi.admin.common.response.JsonResponse;
import cn.slipi.admin.common.response.PageResponse;
import cn.slipi.admin.controller.system.BaseController;
import cn.slipi.admin.service.system.entity.Dictionary;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/sys/dict"})
public class DictionaryController
extends BaseController {
    @Autowired
    private DictionaryBiz dictionaryBiz;

    @PreAuthorize(value="hasAuthority('sys:dict:list')")
    @ApiPageParam
    @GetMapping(value={"/page"})
    public PageResponse<Dictionary> page(HttpServletRequest request) {
        PageParam pageParam = new PageParam(request);
        return new PageResponse(this.dictionaryBiz.page(pageParam), pageParam.getTotal());
    }

    @PreAuthorize(value="hasAuthority('sys:dict:list')")
    @GetMapping
    public PageResponse<Dictionary> list(HttpServletRequest request) {
        PageParam pageParam = new PageParam(request);
        return new PageResponse(this.dictionaryBiz.list(pageParam));
    }

    @PreAuthorize(value="hasAuthority('sys:dict:list')")
    @GetMapping(value={"/{id}"})
    public JsonResponse get(@PathVariable(value="id") Integer id) {
        return JsonResponse.ok().setData((Object)this.dictionaryBiz.get(id));
    }

    @PreAuthorize(value="hasAuthority('sys:dict:save')")
    @PostMapping
    public JsonResponse add(@RequestBody Dictionary dictionary) {
        if (this.dictionaryBiz.add(dictionary)) {
            return JsonResponse.ok();
        }
        return JsonResponse.fail();
    }

    @PreAuthorize(value="hasAuthority('sys:dict:update')")
    @PutMapping
    public JsonResponse update(@RequestBody Dictionary dictionary) {
        if (this.dictionaryBiz.update(dictionary)) {
            return JsonResponse.ok();
        }
        return JsonResponse.fail();
    }

    @PreAuthorize(value="hasAuthority('sys:dict:remove')")
    @DeleteMapping(value={"/{id}"})
    public JsonResponse remove(@PathVariable(value="id") Integer id) {
        if (this.dictionaryBiz.remove(id)) {
            return JsonResponse.ok();
        }
        return JsonResponse.fail();
    }

    @PreAuthorize(value="hasAuthority('sys:dict:save')")
    @PostMapping(value={"/batch"})
    public JsonResponse saveBatch(@RequestBody List<Dictionary> list) {
        if (this.dictionaryBiz.saveBatch(list)) {
            return JsonResponse.ok();
        }
        return JsonResponse.fail();
    }

    @PreAuthorize(value="hasAuthority('sys:dict:remove')")
    @DeleteMapping(value={"/batch"})
    public JsonResponse removeBatch(@RequestBody List<Integer> ids) {
        if (this.dictionaryBiz.removeBatch(ids)) {
            return JsonResponse.ok();
        }
        return JsonResponse.fail();
    }
}

