/*
 * Decompiled with CFR 0.152.
 */
package cn.slipi.admin.controller.system;

import cn.slipi.admin.biz.system.FileBiz;
import cn.slipi.admin.common.annotation.OperationLog;
import cn.slipi.admin.common.response.JsonResponse;
import cn.slipi.admin.common.response.PageResponse;
import cn.slipi.admin.common.util.FileServerUtil;
import java.io.File;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/file"})
public class FileController {
    @Autowired
    private FileBiz fileBiz;

    @GetMapping(value={"/download/{dir}/{name:.+}"})
    public void download(@PathVariable(value="dir") String dir, @PathVariable(value="name") String name, HttpServletResponse response, HttpServletRequest request) {
        FileServerUtil.preview((File)new File(this.fileBiz.getUploadDir(), dir + "/" + name), (boolean)true, null, (String)this.fileBiz.getPdfOutDir(), (HttpServletResponse)response, (HttpServletRequest)request);
    }

    @GetMapping(value={"/thumbnail/{dir}/{name:.+}"})
    public void thumbnail(@PathVariable(value="dir") String dir, @PathVariable(value="name") String name, HttpServletResponse response, HttpServletRequest request) {
        FileServerUtil.previewThumbnail((File)new File(this.fileBiz.getUploadDir(), dir + "/" + name), (File)new File(this.fileBiz.getUploadSmDir(), dir + "/" + name), (Integer)this.fileBiz.thumbnailSize, (String)this.fileBiz.openOfficeHome, (HttpServletResponse)response, (HttpServletRequest)request);
    }

    @GetMapping(value={"/{dir}/{name:.+}"})
    public void preview(@PathVariable(value="dir") String dir, @PathVariable(value="name") String name, HttpServletResponse response, HttpServletRequest request) {
        FileServerUtil.preview((File)new File(this.fileBiz.getUploadDir(), dir + "/" + name), (String)this.fileBiz.getPdfOutDir(), (String)this.fileBiz.openOfficeHome, (HttpServletResponse)response, (HttpServletRequest)request);
    }

    @PreAuthorize(value="hasAuthority('sys:file:remove')")
    @OperationLog(value="\u6587\u4ef6\u7ba1\u7406", desc="\u5220\u9664\u6587\u4ef6", result=true)
    @DeleteMapping(value={"/remove"})
    public JsonResponse remove(String path) {
        if (this.fileBiz.remove(path)) {
            return JsonResponse.ok();
        }
        return JsonResponse.fail();
    }

    @PreAuthorize(value="hasAuthority('sys:file:list')")
    @GetMapping(value={"/list"})
    public PageResponse<Map<String, Object>> list(String directory, String sort, String order) {
        return new PageResponse(this.fileBiz.list(directory, sort, order));
    }
}

