/*
 * Decompiled with CFR 0.152.
 */
package cn.slipi.admin.controller.system;

import cn.slipi.admin.biz.system.MainBiz;
import cn.slipi.admin.common.annotation.OperationLog;
import cn.slipi.admin.common.response.JsonResponse;
import cn.slipi.admin.controller.system.BaseController;
import cn.slipi.admin.service.system.entity.User;
import com.wf.captcha.SpecCaptcha;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api"})
public class MainController
extends BaseController {
    @Autowired
    private MainBiz mainBiz;

    @PostMapping(value={"/login"})
    public void login(String username, String password) {
    }

    @GetMapping(value={"/main/menu"})
    public JsonResponse userMenu() {
        return JsonResponse.ok().setData((Object)this.mainBiz.userMenu(this.getLoginUser()));
    }

    @GetMapping(value={"/main/user"})
    public JsonResponse userInfo() {
        return JsonResponse.ok().setData((Object)this.mainBiz.userInfo(this.getLoginUser()));
    }

    @PreAuthorize(value="hasAuthority('main:user:update')")
    @OperationLog(value="\u767b\u5f55\u8ba4\u8bc1", desc="\u4fee\u6539\u4e2a\u4eba\u4fe1\u606f", result=true)
    @PutMapping(value={"/main/user"})
    public JsonResponse updateInfo(User user) {
        User upUser = this.mainBiz.updateInfo(user, this.getLoginUser());
        if (upUser != null) {
            return JsonResponse.ok().setData((Object)upUser);
        }
        return JsonResponse.fail();
    }

    @PreAuthorize(value="hasAuthority('main:user:password')")
    @OperationLog(value="\u767b\u5f55\u8ba4\u8bc1", desc="\u4fee\u6539\u81ea\u5df1\u5bc6\u7801", result=true)
    @PutMapping(value={"/main/password"})
    public JsonResponse updatePsw(String oldPsw, String newPsw) {
        if (this.mainBiz.updatePsw(oldPsw, newPsw, this.getLoginUser())) {
            return JsonResponse.ok();
        }
        return JsonResponse.fail();
    }

    @GetMapping(value={"/file/captcha"})
    public JsonResponse captcha(HttpServletRequest request) {
        SpecCaptcha specCaptcha = new SpecCaptcha(130, 48, 5);
        return JsonResponse.ok().setData((Object)specCaptcha.toBase64()).put("text", (Object)specCaptcha.text().toLowerCase());
    }
}

