/*
 * Decompiled with CFR 0.152.
 */
package cn.slipi.admin.controller.system;

import cn.slipi.admin.biz.system.MenuBiz;
import cn.slipi.admin.common.annotation.ApiPageParam;
import cn.slipi.admin.common.annotation.OperationLog;
import cn.slipi.admin.common.page.PageParam;
import cn.slipi.admin.common.response.JsonResponse;
import cn.slipi.admin.common.response.PageResponse;
import cn.slipi.admin.controller.system.BaseController;
import cn.slipi.admin.controller.system.form.BatchForm;
import cn.slipi.admin.service.system.entity.Menu;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/sys/menu"})
public class MenuController
extends BaseController {
    @Autowired
    private MenuBiz menuBiz;

    @PreAuthorize(value="hasAuthority('sys:menu:list')")
    @ApiPageParam
    @GetMapping(value={"/page"})
    public PageResponse<Menu> page(HttpServletRequest request) {
        PageParam pageParam = new PageParam(request);
        pageParam.setDefaultOrder(new String[]{"sort_number"}, null);
        return new PageResponse(this.menuBiz.page(pageParam), pageParam.getTotal());
    }

    @PreAuthorize(value="hasAuthority('sys:menu:list')")
    @GetMapping
    public PageResponse<Menu> list(HttpServletRequest request) {
        PageParam pageParam = new PageParam(request);
        pageParam.setDefaultOrder(new String[]{"sort_number"}, null);
        return new PageResponse(this.menuBiz.list(pageParam));
    }

    @PreAuthorize(value="hasAuthority('sys:menu:list')")
    @GetMapping(value={"/{id}"})
    public JsonResponse get(@PathVariable(value="id") Integer id) {
        return JsonResponse.ok().setData((Object)this.menuBiz.get(id));
    }

    @OperationLog(value="\u83dc\u5355\u7ba1\u7406", desc="\u6dfb\u52a0", result=true)
    @PostMapping
    public JsonResponse add(@RequestBody Menu menu) {
        if (this.menuBiz.add(menu)) {
            return JsonResponse.ok();
        }
        return JsonResponse.fail();
    }

    @PreAuthorize(value="hasAuthority('sys:menu:update')")
    @OperationLog(value="\u83dc\u5355\u7ba1\u7406", desc="\u4fee\u6539", result=true)
    @PutMapping
    public JsonResponse update(@RequestBody Menu menu) {
        if (this.menuBiz.update(menu)) {
            return JsonResponse.ok();
        }
        return JsonResponse.fail();
    }

    @PreAuthorize(value="hasAuthority('sys:menu:remove')")
    @OperationLog(value="\u83dc\u5355\u7ba1\u7406", desc="\u5220\u9664", result=true)
    @DeleteMapping(value={"/{id}"})
    public JsonResponse remove(@PathVariable(value="id") Integer id) {
        if (this.menuBiz.remove(id)) {
            return JsonResponse.ok();
        }
        return JsonResponse.fail();
    }

    @PreAuthorize(value="hasAuthority('sys:menu:save')")
    @OperationLog(value="\u83dc\u5355\u7ba1\u7406", desc="\u6279\u91cf\u6dfb\u52a0", result=true)
    @PostMapping(value={"/batch"})
    public JsonResponse saveBatch(@RequestBody List<Menu> menuList) {
        if (this.menuBiz.saveBatch(menuList)) {
            return JsonResponse.ok();
        }
        return JsonResponse.fail();
    }

    @PreAuthorize(value="hasAuthority('sys:menu:update')")
    @OperationLog(value="\u83dc\u5355\u7ba1\u7406", desc="\u6279\u91cf\u4fee\u6539", result=true)
    @PutMapping(value={"/batch"})
    public JsonResponse updateBatch(@RequestBody BatchForm<Menu> batchForm) {
        if (this.menuBiz.updateBatch(batchForm)) {
            return JsonResponse.ok();
        }
        return JsonResponse.fail();
    }

    @PreAuthorize(value="hasAuthority('sys:menu:remove')")
    @OperationLog(value="\u83dc\u5355\u7ba1\u7406", desc="\u6279\u91cf\u5220\u9664", result=true)
    @DeleteMapping(value={"/batch"})
    public JsonResponse removeBatch(@RequestBody List<Integer> ids) {
        if (this.menuBiz.removeBatch(ids)) {
            return JsonResponse.ok();
        }
        return JsonResponse.fail();
    }
}

