/*
 * Decompiled with CFR 0.152.
 */
package cn.slipi.admin.controller.system;

import cn.slipi.admin.biz.system.OrganizationBiz;
import cn.slipi.admin.common.annotation.ApiPageParam;
import cn.slipi.admin.common.annotation.OperationLog;
import cn.slipi.admin.common.page.PageParam;
import cn.slipi.admin.common.response.JsonResponse;
import cn.slipi.admin.common.response.PageResponse;
import cn.slipi.admin.controller.system.BaseController;
import cn.slipi.admin.controller.system.form.BatchForm;
import cn.slipi.admin.service.system.entity.Organization;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/sys/organization"})
public class OrganizationController
extends BaseController {
    @Autowired
    private OrganizationBiz organizationBiz;

    @PreAuthorize(value="hasAuthority('sys:org:list')")
    @ApiPageParam
    @GetMapping(value={"/page"})
    public PageResponse<Organization> page(HttpServletRequest request) {
        PageParam pageParam = new PageParam(request);
        return new PageResponse(this.organizationBiz.page(pageParam), pageParam.getTotal());
    }

    @PreAuthorize(value="hasAuthority('sys:org:list')")
    @GetMapping
    public PageResponse<Organization> list(HttpServletRequest request) {
        PageParam pageParam = new PageParam(request);
        List records = this.organizationBiz.list(pageParam);
        return new PageResponse(pageParam.sortRecords(records));
    }

    @PreAuthorize(value="hasAuthority('sys:org:list')")
    @GetMapping(value={"/{id}"})
    public JsonResponse get(@PathVariable(value="id") Integer id) {
        PageParam pageParam = new PageParam();
        pageParam.put("organizationId", (Object)id);
        return JsonResponse.ok().setData((Object)this.organizationBiz.get(pageParam));
    }

    @PreAuthorize(value="hasAuthority('sys:org:save')")
    @OperationLog(value="\u673a\u6784\u7ba1\u7406", desc="\u6dfb\u52a0", result=true)
    @PostMapping
    public JsonResponse add(@RequestBody Organization organization) {
        if (this.organizationBiz.add(organization)) {
            return JsonResponse.ok();
        }
        return JsonResponse.fail();
    }

    @PreAuthorize(value="hasAuthority('sys:org:update')")
    @OperationLog(value="\u673a\u6784\u7ba1\u7406", desc="\u4fee\u6539", result=true)
    @PutMapping
    public JsonResponse update(@RequestBody Organization organization) {
        if (this.organizationBiz.update(organization)) {
            return JsonResponse.ok();
        }
        return JsonResponse.fail();
    }

    @PreAuthorize(value="hasAuthority('sys:org:remove')")
    @OperationLog(value="\u673a\u6784\u7ba1\u7406", desc="\u5220\u9664", result=true)
    @DeleteMapping(value={"/{id}"})
    public JsonResponse remove(@PathVariable(value="id") Integer id) {
        if (this.organizationBiz.remove(id)) {
            return JsonResponse.ok();
        }
        return JsonResponse.fail();
    }

    @PreAuthorize(value="hasAuthority('sys:org:save')")
    @OperationLog(value="\u673a\u6784\u7ba1\u7406", desc="\u6279\u91cf\u6dfb\u52a0", result=true)
    @PostMapping(value={"/batch"})
    public JsonResponse saveBatch(@RequestBody List<Organization> organizationList) {
        if (this.organizationBiz.saveBatch(organizationList)) {
            return JsonResponse.ok();
        }
        return JsonResponse.fail();
    }

    @PreAuthorize(value="hasAuthority('sys:org:update')")
    @OperationLog(value="\u673a\u6784\u7ba1\u7406", desc="\u6279\u91cf\u4fee\u6539", result=true)
    @PutMapping(value={"/batch"})
    public JsonResponse updateBatch(@RequestBody BatchForm<Organization> batchForm) {
        if (this.organizationBiz.updateBatch(batchForm)) {
            return JsonResponse.ok();
        }
        return JsonResponse.fail();
    }

    @PreAuthorize(value="hasAuthority('sys:org:remove')")
    @OperationLog(value="\u673a\u6784\u7ba1\u7406", desc="\u6279\u91cf\u5220\u9664", result=true)
    @DeleteMapping(value={"/batch"})
    public JsonResponse removeBatch(@RequestBody List<Integer> ids) {
        if (this.organizationBiz.removeBatch(ids)) {
            return JsonResponse.ok();
        }
        return JsonResponse.fail();
    }
}

