/*
 * Decompiled with CFR 0.152.
 */
package cn.slipi.admin.controller.system;

import cn.slipi.admin.biz.system.RoleBiz;
import cn.slipi.admin.common.annotation.ApiPageParam;
import cn.slipi.admin.common.annotation.OperationLog;
import cn.slipi.admin.common.page.PageParam;
import cn.slipi.admin.common.response.JsonResponse;
import cn.slipi.admin.common.response.PageResponse;
import cn.slipi.admin.controller.system.BaseController;
import cn.slipi.admin.service.system.entity.Role;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/sys/role"})
public class RoleController
extends BaseController {
    @Autowired
    private RoleBiz roleBiz;

    @PreAuthorize(value="hasAuthority('sys:role:list')")
    @ApiPageParam
    @GetMapping(value={"/page"})
    public PageResponse<Role> page(HttpServletRequest request) {
        PageParam pageParam = new PageParam(request);
        return new PageResponse(this.roleBiz.page(pageParam), pageParam.getTotal());
    }

    @PreAuthorize(value="hasAuthority('sys:role:list')")
    @GetMapping
    public PageResponse<Role> list(HttpServletRequest request) {
        PageParam pageParam = new PageParam(request);
        return new PageResponse(this.roleBiz.list(pageParam));
    }

    @PreAuthorize(value="hasAuthority('sys:role:list')")
    @GetMapping(value={"/{id}"})
    public JsonResponse get(@PathVariable(value="id") Integer id) {
        return JsonResponse.ok().setData((Object)this.roleBiz.getById(id));
    }

    @PreAuthorize(value="hasAuthority('sys:role:save')")
    @OperationLog(value="\u89d2\u8272\u7ba1\u7406", desc="\u6dfb\u52a0", result=true)
    @PostMapping
    public JsonResponse save(@RequestBody Role role) {
        if (this.roleBiz.save(role)) {
            return JsonResponse.ok();
        }
        return JsonResponse.fail();
    }

    @PreAuthorize(value="hasAuthority('sys:role:update')")
    @OperationLog(value="\u89d2\u8272\u7ba1\u7406", desc="\u4fee\u6539", result=true)
    @PutMapping
    public JsonResponse update(@RequestBody Role role) {
        if (this.roleBiz.update(role)) {
            return JsonResponse.ok();
        }
        return JsonResponse.fail();
    }

    @PreAuthorize(value="hasAuthority('sys:role:remove')")
    @OperationLog(value="\u89d2\u8272\u7ba1\u7406", desc="\u5220\u9664", result=true)
    @DeleteMapping(value={"/{id}"})
    public JsonResponse remove(@PathVariable(value="id") Integer id) {
        if (this.roleBiz.removeById(id)) {
            return JsonResponse.ok();
        }
        return JsonResponse.fail();
    }

    @PreAuthorize(value="hasAuthority('sys:role:save')")
    @OperationLog(value="\u89d2\u8272\u7ba1\u7406", desc="\u6279\u91cf\u6dfb\u52a0", result=true)
    @PostMapping(value={"/batch"})
    public JsonResponse saveBatch(@RequestBody List<Role> list) {
        if (this.roleBiz.saveBatch(list)) {
            return JsonResponse.ok();
        }
        return JsonResponse.fail();
    }

    @PreAuthorize(value="hasAuthority('sys:role:remove')")
    @OperationLog(value="\u89d2\u8272\u7ba1\u7406", desc="\u6279\u91cf\u5220\u9664", result=true)
    @DeleteMapping(value={"/batch"})
    public JsonResponse removeBatch(@RequestBody List<Integer> ids) {
        if (this.roleBiz.removeByIds(ids)) {
            return JsonResponse.ok();
        }
        return JsonResponse.fail();
    }
}

