/*
 * Decompiled with CFR 0.152.
 */
package cn.slipi.admin.controller.system;

import cn.slipi.admin.biz.system.RoleMenuBiz;
import cn.slipi.admin.biz.system.vo.rolemenu.RoleMenuVo;
import cn.slipi.admin.common.annotation.OperationLog;
import cn.slipi.admin.common.response.JsonResponse;
import cn.slipi.admin.common.response.PageResponse;
import cn.slipi.admin.controller.system.BaseController;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/sys/role/menu"})
public class RoleMenuController
extends BaseController {
    @Autowired
    private RoleMenuBiz roleMenuBiz;

    @PreAuthorize(value="hasAuthority('sys:role:list')")
    @ResponseBody
    @GetMapping
    public PageResponse<RoleMenuVo> list(Integer roleId) {
        return new PageResponse(this.roleMenuBiz.getList(roleId));
    }

    @PreAuthorize(value="hasAuthority('sys:role:update')")
    @OperationLog(value="\u89d2\u8272\u7ba1\u7406", desc="\u6dfb\u52a0\u89d2\u8272\u83dc\u5355")
    @ResponseBody
    @PostMapping
    public JsonResponse addRoleAuth(Integer roleId, Integer menuId) {
        if (this.roleMenuBiz.addRoleAuth(roleId, menuId)) {
            return JsonResponse.ok();
        }
        return JsonResponse.fail();
    }

    @PreAuthorize(value="hasAuthority('sys:role:update')")
    @OperationLog(value="\u89d2\u8272\u7ba1\u7406", desc="\u79fb\u9664\u89d2\u8272\u83dc\u5355")
    @ResponseBody
    @DeleteMapping
    public JsonResponse removeRoleAuth(Integer roleId, Integer menuId) {
        if (this.roleMenuBiz.removeRoleAuth(roleId, menuId)) {
            return JsonResponse.ok();
        }
        return JsonResponse.fail();
    }

    @PreAuthorize(value="hasAuthority('sys:role:auth') or @sc.checkAdmin()")
    @OperationLog(value="\u89d2\u8272\u6388\u6743", desc="\u89d2\u8272\u6388\u6743")
    @Transactional(rollbackFor={RuntimeException.class})
    @ResponseBody
    @PutMapping(value={"/{id}"})
    public JsonResponse setRoleAuth(@PathVariable(value="id") Integer roleId, @RequestBody List<Integer> menuIds) {
        if (this.roleMenuBiz.setRoleAuth(roleId, menuIds)) {
            return JsonResponse.ok();
        }
        return JsonResponse.fail();
    }
}

