/*
 * Decompiled with CFR 0.152.
 */
package cn.slipi.admin.controller.system;

import cn.slipi.admin.biz.system.SiteMessageBiz;
import cn.slipi.admin.biz.system.vo.message.SiteMessageVo;
import cn.slipi.admin.common.annotation.ApiPageParam;
import cn.slipi.admin.common.annotation.OperationLog;
import cn.slipi.admin.common.page.PageParam;
import cn.slipi.admin.common.response.JsonResponse;
import cn.slipi.admin.common.response.PageResponse;
import cn.slipi.admin.controller.system.BaseController;
import cn.slipi.admin.controller.system.form.notice.MessageInfo;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.websocket.server.PathParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/sys/site/message"})
public class SiteMessageController
extends BaseController {
    @Autowired
    private SiteMessageBiz siteMessageBiz;

    @PreAuthorize(value="hasAuthority('sys:site:message:list')")
    @ApiPageParam
    @GetMapping(value={"/page"})
    public PageResponse<SiteMessageVo> page(HttpServletRequest request) {
        PageParam pageParam = new PageParam(request);
        return new PageResponse(this.siteMessageBiz.page(pageParam), pageParam.getTotal());
    }

    @PreAuthorize(value="hasAuthority('sys:site:message:wait:list')")
    @ApiPageParam
    @GetMapping(value={"/wait/list"})
    public JsonResponse list(@PathParam(value="type") String type) {
        return JsonResponse.ok().setData((Object)this.siteMessageBiz.list(type, this.getLoginUser()));
    }

    @PreAuthorize(value="hasAuthority('sys:site:message:read')")
    @OperationLog(value="\u7ad9\u5185\u6d88\u606f\u5173\u8054", desc="\u6807\u4e3a\u5df2\u8bfb", result=true)
    @PostMapping(value={"/read"})
    public JsonResponse read(@Validated @RequestBody List<MessageInfo> form) {
        if (this.siteMessageBiz.read(form)) {
            return JsonResponse.ok();
        }
        return JsonResponse.fail();
    }
}

