/*
 * Decompiled with CFR 0.152.
 */
package cn.slipi.admin.controller.system;

import cn.hutool.core.util.StrUtil;
import cn.slipi.admin.biz.system.UserBiz;
import cn.slipi.admin.biz.system.vo.user.UserVo;
import cn.slipi.admin.common.annotation.ApiPageParam;
import cn.slipi.admin.common.annotation.OperationLog;
import cn.slipi.admin.common.page.PageParam;
import cn.slipi.admin.common.response.JsonResponse;
import cn.slipi.admin.common.response.PageResponse;
import cn.slipi.admin.controller.system.BaseController;
import cn.slipi.admin.controller.system.form.BatchForm;
import cn.slipi.admin.controller.system.form.user.AddForm;
import cn.slipi.admin.controller.system.form.user.UpdateForm;
import cn.slipi.admin.service.system.entity.User;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Validated
@RestController
@RequestMapping(value={"/api/sys/user"})
public class UserController
extends BaseController {
    @Autowired
    private UserBiz userBiz;

    @PreAuthorize(value="hasAuthority('sys:user:list')")
    @ApiPageParam
    @GetMapping(value={"/page"})
    public PageResponse<UserVo> page(HttpServletRequest request) {
        PageParam pageParam = new PageParam(request);
        return new PageResponse(this.userBiz.page(pageParam), pageParam.getTotal());
    }

    @PreAuthorize(value="hasAuthority('sys:user:list')")
    @GetMapping
    public PageResponse<UserVo> list(HttpServletRequest request) {
        PageParam pageParam = new PageParam(request);
        return new PageResponse(this.userBiz.list(pageParam));
    }

    @PreAuthorize(value="hasAuthority('sys:user:list')")
    @GetMapping(value={"/{id}"})
    public JsonResponse get(@PathVariable(value="id") Integer id) {
        return JsonResponse.ok().setData((Object)this.userBiz.getById(id));
    }

    @PreAuthorize(value="hasAuthority('sys:user:save')")
    @OperationLog(value="\u7528\u6237\u7ba1\u7406", desc="\u6dfb\u52a0", result=true)
    @PostMapping
    public JsonResponse add(@Validated @RequestBody AddForm form) {
        if (this.userBiz.add(form)) {
            return JsonResponse.ok();
        }
        return JsonResponse.fail();
    }

    @PreAuthorize(value="hasAuthority('sys:user:update')")
    @OperationLog(value="\u7528\u6237\u7ba1\u7406", desc="\u4fee\u6539", result=true)
    @PutMapping
    public JsonResponse update(@RequestBody User user) {
        if (this.userBiz.update(user)) {
            return JsonResponse.ok();
        }
        return JsonResponse.fail();
    }

    @PreAuthorize(value="hasAuthority('sys:user:update')")
    @OperationLog(value="\u7528\u6237\u7ba1\u7406", desc="\u4fee\u6539", result=true)
    @PutMapping(value={"/update/{id}"})
    public JsonResponse updateById(@PathVariable Integer id, @RequestBody UpdateForm updateForm) {
        if (this.userBiz.updateById(id, updateForm)) {
            return JsonResponse.ok();
        }
        return JsonResponse.fail();
    }

    @PreAuthorize(value="hasAuthority('sys:user:init')")
    @OperationLog(value="\u7528\u6237\u7ba1\u7406", desc="\u91cd\u7f6e\u5bc6\u7801", result=true)
    @PutMapping(value={"/init/{id}"})
    public JsonResponse initPass(@PathVariable Integer id) {
        if (this.userBiz.initPass(id)) {
            return JsonResponse.ok();
        }
        return JsonResponse.fail();
    }

    @PreAuthorize(value="hasAuthority('sys:user:remove')")
    @OperationLog(value="\u7528\u6237\u7ba1\u7406", desc="\u5220\u9664", result=true)
    @DeleteMapping(value={"/{id}"})
    public JsonResponse remove(@PathVariable(value="id") Integer id) {
        if (this.userBiz.remove(id, this.getLoginUser())) {
            return JsonResponse.ok();
        }
        return JsonResponse.fail();
    }

    @PreAuthorize(value="hasAuthority('sys:user:update')")
    @OperationLog(value="\u7528\u6237\u7ba1\u7406", desc="\u6279\u91cf\u4fee\u6539", result=true)
    @PutMapping(value={"/batch"})
    public JsonResponse removeBatch(@RequestBody BatchForm<User> batchForm) {
        if (this.userBiz.removeBatch(batchForm)) {
            return JsonResponse.ok();
        }
        return JsonResponse.fail();
    }

    @PreAuthorize(value="hasAuthority('sys:user:remove')")
    @OperationLog(value="\u7528\u6237\u7ba1\u7406", desc="\u6279\u91cf\u5220\u9664", result=true)
    @DeleteMapping(value={"/batch"})
    public JsonResponse deleteBatch(@RequestBody List<Integer> ids) {
        if (this.userBiz.deleteBatch(ids)) {
            return JsonResponse.ok();
        }
        return JsonResponse.fail();
    }

    @PreAuthorize(value="hasAuthority('sys:user:update')")
    @OperationLog(value="\u7528\u6237\u7ba1\u7406", desc="\u4fee\u6539\u72b6\u6001", result=true)
    @PutMapping(value={"/state/{id}"})
    public JsonResponse updateState(@PathVariable(value="id") Integer id, Integer state) {
        if (this.userBiz.updateState(id, state, this.getLoginUser())) {
            return JsonResponse.ok();
        }
        return JsonResponse.fail();
    }

    @PreAuthorize(value="hasAuthority('sys:user:update')")
    @OperationLog(value="\u7528\u6237\u7ba1\u7406", desc="\u6279\u91cf\u4fee\u6539\u72b6\u6001", result=true)
    @PutMapping(value={"/state/batch"})
    public JsonResponse updateStateBatch(@RequestBody BatchForm<User> batchForm) {
        if (this.userBiz.updateStateBatch(batchForm)) {
            return JsonResponse.ok();
        }
        return JsonResponse.fail();
    }

    @PreAuthorize(value="hasAuthority('sys:user:update')")
    @OperationLog(value="\u7528\u6237\u7ba1\u7406", desc="\u91cd\u7f6e\u5bc6\u7801", result=true)
    @PutMapping(value={"/psw/{id}"})
    public JsonResponse resetPsw(@PathVariable(value="id") Integer id, String password) {
        if (this.userBiz.resetPsw(id, password)) {
            return JsonResponse.ok();
        }
        return JsonResponse.fail();
    }

    @PreAuthorize(value="hasAuthority('sys:user:update')")
    @OperationLog(value="\u7528\u6237\u7ba1\u7406", desc="\u6279\u91cf\u91cd\u7f6e\u5bc6\u7801", result=true)
    @PutMapping(value={"/psw/batch"})
    public JsonResponse resetPswBatch(@RequestBody BatchForm<User> batchForm) {
        if (this.userBiz.resetPswBatch(batchForm)) {
            return JsonResponse.ok();
        }
        return JsonResponse.fail();
    }

    @PreAuthorize(value="hasAuthority('sys:user:save')")
    @OperationLog(value="\u7528\u6237\u7ba1\u7406", desc="excel\u5bfc\u5165", result=true)
    @Transactional
    @PostMapping(value={"/import"})
    public JsonResponse importBatch(MultipartFile file) {
        String result = this.userBiz.importBatch(file);
        if (StrUtil.isEmpty((CharSequence)result)) {
            JsonResponse.ok((String)result);
        }
        return JsonResponse.fail();
    }
}

