/*
 * Decompiled with CFR 0.152.
 */
package cn.slipi.admin.core.scheduler;

import cn.slipi.admin.common.config.AdminConfig;
import cn.slipi.admin.core.thread.MonitorRegistryHelper;
import cn.slipi.monitor.core.sapi.StandardInterface;
import cn.slipi.monitor.core.sapi.client.StandardInterfaceClient;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MonitorScheduler {
    private static final Logger logger = LoggerFactory.getLogger(MonitorScheduler.class);
    private static final ConcurrentMap<String, StandardInterface> STANDARD_INTERFACE_REPOSITORY = new ConcurrentHashMap();

    public void init() {
        MonitorRegistryHelper.getInstance().start();
        logger.info(">>>>>>>>> init monitor registry success.");
    }

    public void destroy() {
        MonitorRegistryHelper.getInstance().toStop();
    }

    public static StandardInterface getStandardInterface(String address) {
        if (address == null || address.trim().length() == 0) {
            return null;
        }
        StandardInterface standardInterface = (StandardInterface)STANDARD_INTERFACE_REPOSITORY.get(address = address.trim());
        if (standardInterface != null) {
            return standardInterface;
        }
        standardInterface = new StandardInterfaceClient(address, AdminConfig.getAdminConfig().getAccessToken());
        STANDARD_INTERFACE_REPOSITORY.put(address, standardInterface);
        return standardInterface;
    }
}

