/*
 * Decompiled with CFR 0.152.
 */
package cn.slipi.admin.core.thread;

import cn.slipi.admin.common.util.cache.JedisClusterUtil;
import cn.slipi.admin.core.thread.model.SystemInfo;
import cn.slipi.admin.service.client.entity.ClientRegistry;
import cn.slipi.admin.service.monitor.dao.AppMapper;
import cn.slipi.admin.service.monitor.dao.ServerMapper;
import cn.slipi.admin.service.monitor.entity.App;
import cn.slipi.admin.service.monitor.entity.Server;
import cn.slipi.monitor.core.util.GsonUtil;
import cn.slipi.monitor.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Component
public class AsyncService {
    private static final Logger logger = LoggerFactory.getLogger(AsyncService.class);
    @Autowired
    private AppMapper appMapper;
    @Autowired
    private ServerMapper serverMapper;
    @Autowired
    private JedisClusterUtil jedisClusterUtil;

    @Async
    public void syncAppAndServer(ClientRegistry client) {
        QueryWrapper appQueryWrapper = new QueryWrapper();
        appQueryWrapper.eq((Object)"app_name", (Object)client.getAppName());
        App app = (App)this.appMapper.selectOne((Wrapper)appQueryWrapper);
        if (app == null) {
            app = new App(client.getAppName(), client.getAppName(), client.getPort());
            this.appMapper.insert((Object)app);
            logger.info(">>>>>>>>>>> sync client app {}", (Object)app);
        }
        QueryWrapper serverQueryWrapper = new QueryWrapper();
        ((QueryWrapper)((QueryWrapper)serverQueryWrapper.eq((Object)"host", (Object)client.getHost())).or()).eq((Object)"lan", (Object)client.getLan());
        Server server = (Server)this.serverMapper.selectOne((Wrapper)serverQueryWrapper);
        if (server == null) {
            if (StrUtil.isBlank((CharSequence)client.getHost())) {
                client.setHost(String.format("%s-w", client.getLan()));
            }
            server = new Server(String.format("%s-%s", client.getAppName(), client.getLan()), client.getHost(), client.getLan());
            this.serverMapper.insert((Object)server);
            logger.info(">>>>>>>>>>> sync client server {}", (Object)server);
        }
        String listenKey = "";
        listenKey = !StrUtil.isBlank((CharSequence)client.getLan()) ? String.format("%s:%s", "monitor:client:server:listen:lan", client.getLan()) : String.format("%s:%s", "monitor:client:server:listen:host", client.getHost());
        this.jedisClusterUtil.set(listenKey, "1", 30);
        logger.info(">>>>>>>>>>> SET server listen {}", (Object)listenKey);
    }

    @Async
    public void setSystemInfo(ClientRegistry client, SystemInfo systemInfo) {
        systemInfo.setExpire(Integer.valueOf(60));
        systemInfo.setUpdateTime(new Date());
        if (!StrUtil.isBlank((CharSequence)client.getHost())) {
            String hostKey = String.format("%s:%s", "monitor:client:host", client.getHost());
            logger.info(">>>>>>>>>>> SET host system key = {}", (Object)hostKey);
            this.jedisClusterUtil.set(hostKey, GsonUtil.toJson((Object)systemInfo), 60);
        }
        if (!StrUtil.isBlank((CharSequence)client.getLan())) {
            String lanKey = String.format("%s:%s", "monitor:client:lan", client.getLan());
            logger.info(">>>>>>>>>>> SET lan system key = {}", (Object)lanKey);
            this.jedisClusterUtil.set(lanKey, GsonUtil.toJson((Object)systemInfo), 60);
        }
    }

    @Async
    public void removeSystemInfo(String host, String lan) {
        if (!StrUtil.isBlank((CharSequence)host)) {
            String hostKey = String.format("%s:%s", "monitor:client:host", host);
            logger.info(">>>>>>>>>>> REMOVE host system key = {}", (Object)hostKey);
            this.jedisClusterUtil.deleteKey(hostKey);
        }
        if (!StrUtil.isBlank((CharSequence)lan)) {
            String lanKey = String.format("%s:%s", "monitor:client:lan", lan);
            logger.info(">>>>>>>>>>> REMOVE lan system key = {}", (Object)lanKey);
            this.jedisClusterUtil.deleteKey(lanKey);
        }
    }
}

