/*
 * Decompiled with CFR 0.152.
 */
package cn.slipi.admin.core.thread;

import cn.slipi.admin.common.config.AdminConfig;
import cn.slipi.admin.core.thread.model.ClientRegistryDTO;
import cn.slipi.admin.core.thread.model.SystemInfo;
import cn.slipi.admin.service.client.entity.ClientRegistry;
import cn.slipi.monitor.core.common.response.Result;
import cn.slipi.monitor.core.model.RegistryParam;
import cn.slipi.monitor.core.util.GsonUtil;
import cn.slipi.monitor.core.util.StrUtil;
import cn.slipi.monitor.core.util.os.model.Cpu;
import cn.slipi.monitor.core.util.os.model.Jvm;
import cn.slipi.monitor.core.util.os.model.Mem;
import cn.slipi.monitor.core.util.os.model.Sys;
import cn.slipi.monitor.core.util.os.model.SysFile;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MonitorRegistryHelper {
    private static final Logger logger = LoggerFactory.getLogger(MonitorRegistryHelper.class);
    private static final MonitorRegistryHelper INSTANCE = new MonitorRegistryHelper();
    private ThreadPoolExecutor registryOrRemoveThreadPool = null;
    private Thread registryMonitorThread;
    private volatile boolean toStop = false;

    public static MonitorRegistryHelper getInstance() {
        return INSTANCE;
    }

    public void start() {
        this.registryOrRemoveThreadPool = new ThreadPoolExecutor(2, 10, 30L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(2000), r -> new Thread(r, "monitor, admin MonitorRegistryHelper-registryOrRemoveThreadPool-" + r.hashCode()), (r, executor) -> {
            r.run();
            logger.warn(">>>>>>>>>>> monitor, registry or remove too fast, match thread pool rejected handler(run now).");
        });
        this.registryMonitorThread = new Thread(() -> {
            while (!this.toStop) {
                block6: {
                    try {
                        Long activeTimestamp = System.currentTimeMillis() - 60000L;
                        List ids = AdminConfig.getAdminConfig().getClientRegistryMapper().findDead(activeTimestamp);
                        if (ids != null && ids.size() > 0) {
                            AdminConfig.getAdminConfig().getClientRegistryMapper().deleteBatchIds((Collection)ids);
                        }
                        List clientRegistryActiveList = AdminConfig.getAdminConfig().getClientRegistryMapper().findActive(activeTimestamp);
                        clientRegistryActiveList.forEach(client -> {
                            Future cpu = AdminConfig.getAdminConfig().getAsyncCall().monitor("/cpu", client);
                            Future mem = AdminConfig.getAdminConfig().getAsyncCall().monitor("/mem", client);
                            Future jvm = AdminConfig.getAdminConfig().getAsyncCall().monitor("/jvm", client);
                            Future system = AdminConfig.getAdminConfig().getAsyncCall().monitor("/sys", client);
                            Future sysFile = AdminConfig.getAdminConfig().getAsyncCall().monitor("/sysFile", client);
                            SystemInfo systemInfo = new SystemInfo();
                            try {
                                while (!(cpu.isDone() && mem.isDone() && jvm.isDone() && system.isDone() && sysFile.isDone())) {
                                    if ("error".equals(cpu.get()) && "error".equals(mem.get()) && "error".equals(jvm.get()) && "error".equals(system.get()) && "error".equals(sysFile.get())) {
                                        logger.warn(">>>>>>>>>>> call active client error: host = {},lan = {}", (Object)client.getHost(), (Object)client.getLan());
                                        AdminConfig.getAdminConfig().getAsyncService().removeSystemInfo(client.getHost(), client.getLan());
                                        continue;
                                    }
                                    if (!"error".equals(cpu.get())) {
                                        systemInfo.setCpu((Cpu)GsonUtil.fromJson((String)((String)cpu.get()), Cpu.class));
                                    }
                                    if (!"error".equals(mem.get())) {
                                        systemInfo.setMem((Mem)GsonUtil.fromJson((String)((String)mem.get()), Mem.class));
                                    }
                                    if (!"error".equals(jvm.get())) {
                                        systemInfo.setJvm((Jvm)GsonUtil.fromJson((String)((String)jvm.get()), Jvm.class));
                                    }
                                    if (!"error".equals(system.get())) {
                                        systemInfo.setSystem((Sys)GsonUtil.fromJson((String)((String)system.get()), Sys.class));
                                    }
                                    if (!"error".equals(sysFile.get())) {
                                        systemInfo.setIo(GsonUtil.fromJsonList((String)((String)sysFile.get()), SysFile.class));
                                    }
                                    AdminConfig.getAdminConfig().getAsyncService().setSystemInfo(client, systemInfo);
                                    logger.info(">>>>>>>>>>> call active client result:{}", (Object)GsonUtil.toJson((Object)systemInfo));
                                }
                            }
                            catch (Exception e) {
                                logger.error(">>>>>>>>>>> call active client error", (Throwable)e);
                            }
                        });
                    }
                    catch (Exception e) {
                        if (this.toStop) break block6;
                        logger.error(">>>>>>>>>>> lt-monitor, server registry monitor thread error", (Throwable)e);
                    }
                }
                try {
                    TimeUnit.SECONDS.sleep(30L);
                }
                catch (InterruptedException e) {
                    if (this.toStop) continue;
                    logger.error(">>>>>>>>>>> lt-monitor, server registry monitor thread error", (Throwable)e);
                }
            }
            logger.info(">>>>>>>>>>> lt-monitor, server registry monitor thread stop");
        });
        this.registryMonitorThread.setDaemon(true);
        this.registryMonitorThread.setName("lt-monitor, admin MonitorRegistryHelper-registryMonitorThread");
        this.registryMonitorThread.start();
    }

    public void toStop() {
        this.toStop = true;
        this.registryOrRemoveThreadPool.shutdownNow();
        this.registryMonitorThread.interrupt();
        try {
            this.registryMonitorThread.join();
        }
        catch (InterruptedException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public Result<String> registry(RegistryParam registryParam) {
        if (StrUtil.isBlank((CharSequence)registryParam.getAppName()) || StrUtil.isBlank((CharSequence)registryParam.getAddress()) || StrUtil.isBlank((CharSequence)registryParam.getHost()) && StrUtil.isBlank((CharSequence)registryParam.getLan())) {
            return new Result(Result.ERROR_CODE.intValue(), "Illegal Argument.");
        }
        this.registryOrRemoveThreadPool.execute(() -> {
            ClientRegistryDTO clientRegistryDTO = new ClientRegistryDTO(registryParam.getAppName(), registryParam.getHost(), registryParam.getLan(), Integer.valueOf(registryParam.getPort()), Long.valueOf(System.currentTimeMillis()));
            int ret = AdminConfig.getAdminConfig().getClientRegistryMapper().updateTime(clientRegistryDTO);
            ClientRegistry clientRegistry = new ClientRegistry(registryParam.getAppName(), registryParam.getHost(), registryParam.getLan(), Integer.valueOf(registryParam.getServerPort()), Integer.valueOf(registryParam.getPort()), registryParam.getAddress());
            if (ret < 1) {
                int res = AdminConfig.getAdminConfig().getClientRegistryMapper().insert((Object)clientRegistry);
                if (res > 0) {
                    logger.info(String.format("%s(%s:%d):\u6ce8\u518c\u6210\u529f", registryParam.getAppName(), registryParam.getHost(), registryParam.getPort()));
                } else {
                    logger.info(String.format("%s(%s:%d):\u6ce8\u518c\u5931\u8d25", registryParam.getAppName(), registryParam.getHost(), registryParam.getPort()));
                }
            }
            AdminConfig.getAdminConfig().getAsyncService().syncAppAndServer(clientRegistry);
        });
        return new Result(Result.SUCCESS_CODE.intValue(), String.format("%s(%s:%d):\u6ce8\u518c\u6210\u529f", registryParam.getAppName(), registryParam.getHost(), registryParam.getPort()));
    }

    public Result<String> registryRemove(RegistryParam registryParam) {
        if (StrUtil.isBlank((CharSequence)registryParam.getAppName()) || StrUtil.isBlank((CharSequence)registryParam.getAddress()) || StrUtil.isBlank((CharSequence)registryParam.getHost()) && StrUtil.isBlank((CharSequence)registryParam.getLan())) {
            return new Result(Result.ERROR_CODE.intValue(), "Illegal Argument.");
        }
        this.registryOrRemoveThreadPool.execute(() -> {
            ClientRegistryDTO clientRegistryDTO = new ClientRegistryDTO(registryParam.getAppName(), registryParam.getHost(), registryParam.getLan(), Integer.valueOf(registryParam.getPort()), Long.valueOf(System.currentTimeMillis()));
            int res = AdminConfig.getAdminConfig().getClientRegistryMapper().deleteClient(clientRegistryDTO);
            if (res > 0) {
                logger.info(String.format("%s(%s:%d):\u6ce8\u9500\u6210\u529f", registryParam.getAppName(), registryParam.getHost(), registryParam.getPort()));
            } else {
                logger.info(String.format("%s(%s:%d):\u6ce8\u9500\u5931\u8d25", registryParam.getAppName(), registryParam.getHost(), registryParam.getPort()));
            }
            AdminConfig.getAdminConfig().getAsyncService().removeSystemInfo(registryParam.getHost(), registryParam.getLan());
        });
        return new Result(Result.SUCCESS_CODE.intValue(), String.format("%s(%s:%d):\u6ce8\u9500\u6210\u529f", registryParam.getAppName(), registryParam.getHost(), registryParam.getPort()));
    }
}

