/*
 * Decompiled with CFR 0.152.
 */
package cn.slipi.admin.service.system.service.impl;

import cn.slipi.admin.common.enums.ResponseCode;
import cn.slipi.admin.common.exception.BizException;
import cn.slipi.admin.common.page.PageParam;
import cn.slipi.admin.service.system.dao.MenuMapper;
import cn.slipi.admin.service.system.dao.OrganizationMapper;
import cn.slipi.admin.service.system.dao.UserMapper;
import cn.slipi.admin.service.system.dao.UserRoleMapper;
import cn.slipi.admin.service.system.entity.Menu;
import cn.slipi.admin.service.system.entity.Organization;
import cn.slipi.admin.service.system.entity.Role;
import cn.slipi.admin.service.system.entity.User;
import cn.slipi.admin.service.system.service.UserService;
import cn.slipi.monitor.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class UserServiceImpl
extends ServiceImpl<UserMapper, User>
implements UserService {
    @Autowired
    private UserRoleMapper userRoleMapper;
    @Autowired
    private OrganizationMapper organizationMapper;
    @Autowired
    private MenuMapper menuMapper;

    public User getByUsername(String username) {
        User user = (User)((UserMapper)this.baseMapper).selectOne((Wrapper)new QueryWrapper().eq((Object)"username", (Object)username));
        if (user != null) {
            user.setRoles(this.userRoleMapper.listByUserId(user.getUserId()));
        }
        return user;
    }

    public User getById(Integer userId) {
        return (User)((UserMapper)this.baseMapper).selectOne((Wrapper)new QueryWrapper().eq((Object)"user_id", (Object)userId));
    }

    public User getFullById(Integer userId) {
        List userList = ((UserMapper)this.baseMapper).listAll(new PageParam().put("userId", (Object)userId).getNoPageParam());
        if (userList.size() == 0) {
            return null;
        }
        return this.selectRoleAndAuth((User)userList.get(0));
    }

    public User selectRoleAndAuth(User user) {
        if (user == null) {
            return null;
        }
        user.setRoles(this.userRoleMapper.listByUserId(user.getUserId()));
        return this.selectUserAuth(user);
    }

    public User selectUserAuth(User user) {
        if (user == null) {
            return null;
        }
        List menus = this.menuMapper.listByUserId(user.getUserId(), null);
        ArrayList<Menu> authList = new ArrayList<Menu>();
        for (Menu menu : menus) {
            if (StrUtil.isBlank((CharSequence)menu.getAuthority())) continue;
            authList.add(menu);
        }
        user.setAuthorities(authList);
        return user;
    }

    public List<User> listPage(PageParam<User> page) {
        if (page.getPageData().containsKey("organizationId")) {
            Integer organizationId = Integer.parseInt(page.getPageData().get("organizationId").toString());
            Organization curOrganization = (Organization)this.organizationMapper.selectById((Serializable)organizationId);
            if (curOrganization.getParentId() == 0) {
                page.getPageData().remove("organizationId");
            } else {
                QueryWrapper queryWrapper = new QueryWrapper();
                queryWrapper.eq((Object)"parent_id", (Object)organizationId);
                queryWrapper.eq((Object)"deleted", (Object)0);
                List organizationList = this.organizationMapper.selectList((Wrapper)queryWrapper);
                List organizationIds = organizationList.stream().map(Organization::getOrganizationId).collect(Collectors.toList());
                organizationIds.add(organizationId);
                page.getPageData().put("organizationIds", organizationIds);
            }
        }
        List users = ((UserMapper)this.baseMapper).listPage(page);
        this.selectUserRoles(users);
        return users;
    }

    public List<User> listAll(Map<String, Object> page) {
        List users = ((UserMapper)this.baseMapper).listAll(page);
        this.selectUserRoles(users);
        return users;
    }

    public List<User> listAll() {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"deleted", (Object)0);
        return ((UserMapper)this.baseMapper).selectList((Wrapper)queryWrapper);
    }

    @Transactional(rollbackFor={BizException.class})
    public boolean saveUser(User user) {
        boolean result;
        if (StringUtils.isNotBlank((CharSequence)user.getUsername()) && ((UserMapper)this.baseMapper).selectCount((Wrapper)new QueryWrapper().eq((Object)"username", (Object)user.getUsername())) > 0) {
            throw new BizException(ResponseCode.BIZ_ACCOUNT_EXISTS);
        }
        if (StringUtils.isNotBlank((CharSequence)user.getPhone()) && ((UserMapper)this.baseMapper).selectCount((Wrapper)new QueryWrapper().eq((Object)"phone", (Object)user.getPhone())) > 0) {
            throw new BizException(ResponseCode.BIZ_PHONE_EXISTS);
        }
        if (StringUtils.isNotBlank((CharSequence)user.getEmail()) && ((UserMapper)this.baseMapper).selectCount((Wrapper)new QueryWrapper().eq((Object)"email", (Object)user.getEmail())) > 0) {
            throw new BizException(ResponseCode.BIZ_MAIL_EXISTS);
        }
        if (this.isAdmin(user.getRoleIds())) {
            user.setIsAdmin(Integer.valueOf(1));
        }
        boolean bl = result = ((UserMapper)this.baseMapper).insert((Object)user) > 0;
        if (result) {
            this.addUserRoles(user.getUserId(), user.getRoleIds(), false);
        }
        return result;
    }

    @Transactional(rollbackFor={BizException.class})
    public boolean updateUser(User user) {
        boolean result;
        if (StringUtils.isNotBlank((CharSequence)user.getUsername()) && ((UserMapper)this.baseMapper).selectCount((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"username", (Object)user.getUsername())).ne((Object)"user_id", (Object)user.getUserId())) > 0) {
            throw new BizException(ResponseCode.BIZ_ACCOUNT_EXISTS);
        }
        if (StringUtils.isNotBlank((CharSequence)user.getPhone()) && ((UserMapper)this.baseMapper).selectCount((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"phone", (Object)user.getPhone())).ne((Object)"user_id", (Object)user.getUserId())) > 0) {
            throw new BizException(ResponseCode.BIZ_PHONE_EXISTS);
        }
        if (StringUtils.isNotBlank((CharSequence)user.getEmail()) && ((UserMapper)this.baseMapper).selectCount((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"email", (Object)user.getEmail())).ne((Object)"user_id", (Object)user.getUserId())) > 0) {
            throw new BizException(ResponseCode.BIZ_MAIL_EXISTS);
        }
        if (this.isAdmin(user.getRoleIds())) {
            user.setIsAdmin(Integer.valueOf(1));
        }
        boolean bl = result = ((UserMapper)this.baseMapper).updateById((Object)user) > 0;
        if (result) {
            this.addUserRoles(user.getUserId(), user.getRoleIds(), true);
        }
        return result;
    }

    private boolean isAdmin(List<Integer> roleIds) {
        if (roleIds.size() <= 0) {
            return false;
        }
        Role role = this.userRoleMapper.getAdminByRoleIds(roleIds);
        return role != null;
    }

    public boolean updateInfo(User user) {
        return ((UserMapper)this.baseMapper).updateById((Object)user) > 0;
    }

    public boolean comparePsw(String dbPsw, String inputPsw) {
        return dbPsw != null && new BCryptPasswordEncoder().matches((CharSequence)inputPsw, dbPsw);
    }

    public String encodePsw(String psw) {
        if (psw == null) {
            return null;
        }
        return new BCryptPasswordEncoder().encode((CharSequence)psw);
    }

    @Transactional(rollbackFor={BizException.class})
    public boolean removeById(Integer userId) {
        ((UserMapper)this.baseMapper).deleteById((Serializable)userId);
        this.removeUserRole(userId);
        return true;
    }

    private boolean removeUserRole(Integer userId) {
        return this.userRoleMapper.delete((Wrapper)new UpdateWrapper().eq((Object)"user_id", (Object)userId)) > 0;
    }

    private void selectUserRoles(List<User> users) {
        if (users != null && users.size() > 0) {
            List userIds = users.stream().map(User::getUserId).collect(Collectors.toList());
            List userRoles = this.userRoleMapper.listByUserIds(userIds);
            for (User user : users) {
                List roles = userRoles.stream().filter(d -> user.getUserId().equals(d.getUserId())).collect(Collectors.toList());
                user.setRoles(roles);
            }
        }
    }

    private void addUserRoles(Integer userId, List<Integer> roleIds, boolean deleteOld) {
        if (deleteOld) {
            this.userRoleMapper.delete((Wrapper)new UpdateWrapper().eq((Object)"user_id", (Object)userId));
        }
        if (this.userRoleMapper.insertBatch(userId, roleIds) < roleIds.size()) {
            throw new BizException(ResponseCode.BIZ_OPERATION_FAIL);
        }
    }
}

