/*
 * Decompiled with CFR 0.152.
 */
package cn.sylinx.excel.imp;

import cn.sylinx.excel.imp.DataPersistenceException;
import cn.sylinx.excel.imp.DataQuerySupport;
import cn.sylinx.excel.imp.Filter;
import cn.sylinx.excel.imp.ImportConfig;
import cn.sylinx.horm.core.SqlClient;
import cn.sylinx.horm.core.common.Record;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractDataQuerySupport
implements DataQuerySupport {
    private SqlClient sqlClient;
    private ImportConfig importConfig;
    private Map<Integer, String> sheetColunmSelectMap = new HashMap<Integer, String>();

    public void setSqlClient(SqlClient sqlClient) {
        this.sqlClient = sqlClient;
    }

    public void setImportConfig(ImportConfig importConfig) {
        this.importConfig = importConfig;
    }

    @Override
    public int getMaxRowIndex(int sheetIndex) {
        String sheetTableName = this.getSheetTableName(sheetIndex);
        String sql = "SELECT MAX(" + this.importConfig.getRowIndex() + ") FROM " + sheetTableName;
        Record r = this.sqlClient.queryRecord(sql, new Object[0]);
        return r.getInteger(1);
    }

    @Override
    public Object getCell(int sheetIndex, int rowIndex, int columnIndex) {
        String sheetTableName = this.getSheetTableName(sheetIndex);
        String columnName = this.getColumnName(columnIndex);
        String sql = "SELECT " + columnName + " FROM " + sheetTableName + " WHERE " + this.importConfig.getRowIndex() + " = " + rowIndex;
        Record r = this.sqlClient.queryRecord(sql, new Object[0]);
        return r.get(1);
    }

    @Override
    public List<Object> getRow(int sheetIndex, int rowIndex, boolean isAll) {
        String sheetTableName = this.getSheetTableName(sheetIndex);
        String sql = "SELECT * FROM " + sheetTableName + " WHERE " + this.importConfig.getRowIndex() + " = " + rowIndex;
        Record r = this.sqlClient.queryRecord(sql, new Object[0]);
        ArrayList<Object> rowData = new ArrayList<Object>();
        int maxColumnIndex = this.getMaxColumnIndex(sheetIndex);
        if (isAll) {
            for (int i = 1; i <= maxColumnIndex + 2; ++i) {
                rowData.add(r.get(i));
            }
        } else {
            for (int i = 1; i <= maxColumnIndex; ++i) {
                rowData.add(r.get(i + 2));
            }
        }
        return rowData;
    }

    @Override
    public List<Object> getColumn(int sheetIndex, int columnIndex) {
        String sheetTableName = this.getSheetTableName(sheetIndex);
        String columnName = this.getColumnName(columnIndex);
        String sql = "SELECT " + columnName + " FROM " + sheetTableName + " ORDER BY " + this.importConfig.getRowIndex() + " ASC";
        List records = this.sqlClient.queryRecords(sql, new Object[0]);
        ArrayList<Object> columnDataList = new ArrayList<Object>();
        records.forEach(r -> columnDataList.add(r.get(1)));
        return columnDataList;
    }

    protected String getSheetColunmSelects(int sheetIndex) {
        String sheetColumnSelects = this.sheetColunmSelectMap.get(sheetIndex);
        if (sheetColumnSelects != null) {
            return sheetColumnSelects;
        }
        int maxColumnIndex = this.getMaxColumnIndex(sheetIndex);
        StringBuilder sb = new StringBuilder();
        for (int i = 1; i <= maxColumnIndex; ++i) {
            sb.append(this.getColumnName(i)).append(",");
        }
        sb.deleteCharAt(sb.length() - 1);
        sheetColumnSelects = sb.toString();
        this.sheetColunmSelectMap.put(sheetIndex, sheetColumnSelects);
        return sheetColumnSelects;
    }

    @Override
    public List<List<Object>> getRowsByFilter(int sheetIndex, List<Filter> filters, boolean isAll) {
        if (filters == null || filters.isEmpty()) {
            return Collections.emptyList();
        }
        String sheetTableName = this.getSheetTableName(sheetIndex);
        String sql = "SELECT " + (isAll ? "*" : this.getSheetColunmSelects(sheetIndex)) + " FROM " + sheetTableName + " WHERE ";
        StringBuilder condition = new StringBuilder();
        Object[] params = new Object[filters.size()];
        for (int i = 0; i < filters.size(); ++i) {
            Filter filter = filters.get(i);
            condition.append(this.getColumnName(filter.getColumnIndex())).append(" = ?").append(" AND ");
            params[i] = filter.getValue();
        }
        sql = sql + condition.toString() + " 1=1 ORDER BY " + this.importConfig.getRowIndex() + " ASC";
        List dataList = null;
        try {
            dataList = this.sqlClient.query(sql, params);
        }
        catch (SQLException e) {
            throw new DataPersistenceException(e);
        }
        ArrayList<List<Object>> result = new ArrayList<List<Object>>();
        dataList.forEach(r -> result.add(Arrays.asList(r)));
        return result;
    }

    protected String getSheetTableName(int sheetIndex) {
        return this.importConfig.getTablePrefix() + sheetIndex;
    }

    protected String getColumnName(int columnIndex) {
        return this.importConfig.getColumnPrefix() + columnIndex;
    }
}

