/*
 * Decompiled with CFR 0.152.
 */
package cn.sylinx.excel.imp;

import cn.sylinx.excel.imp.AbstractDataQuerySupport;
import cn.sylinx.excel.imp.DataPersistenceException;
import cn.sylinx.excel.imp.DataPersistenceSupport;
import cn.sylinx.excel.imp.DataQuerySupport;
import cn.sylinx.excel.imp.ExcelCellValueConverterManager;
import cn.sylinx.excel.imp.ImportConfig;
import cn.sylinx.excel.imp.RowData;
import cn.sylinx.excel.imp.ScanDataHandler;
import cn.sylinx.horm.core.SqlClient;
import cn.sylinx.horm.core.datasource.NamedDataSource;
import cn.sylinx.horm.pool.DataSourceWrapperFactory;
import cn.sylinx.horm.starter.DefaultSqlClientInitializor;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDataOperationSupport
extends AbstractDataQuerySupport
implements DataPersistenceSupport,
DataQuerySupport {
    private static final Logger logger = LoggerFactory.getLogger(DefaultDataOperationSupport.class);
    private Map<String, Integer> sheetTableInfo = new HashMap<String, Integer>();
    private Map<String, String> sheetTableInsertSqlTemplate = new HashMap<String, String>();
    private Map<String, Integer> columnLenExtend = new HashMap<String, Integer>();
    private Map<String, Integer> userInputLenExtend = new HashMap<String, Integer>();
    private SqlClient sqlClient;
    private ImportConfig importConfig;
    private String storeFilePath;
    private String scanSqlTemplate;

    public DefaultDataOperationSupport() {
        this("" + System.currentTimeMillis(), new ImportConfig());
    }

    public DefaultDataOperationSupport(ImportConfig importConfig) {
        this("" + System.currentTimeMillis(), importConfig);
    }

    public DefaultDataOperationSupport(String storeFile, ImportConfig importConfig) {
        String defaultStorePath = importConfig.getDefaultStorePath();
        String storeFilePath = defaultStorePath.endsWith(File.separator) ? defaultStorePath + storeFile : defaultStorePath + File.separator + storeFile;
        this.storeFilePath = storeFilePath;
        logger.info("import store file -> {}", (Object)storeFilePath);
        this.sqlClient = this.create(storeFilePath);
        this.importConfig = importConfig;
        this.setSqlClient(this.sqlClient);
        this.setImportConfig(this.importConfig);
        this.scanSqlTemplate = "SELECT * FROM %s WHERE " + importConfig.getRowIndex() + " > ? ORDER BY " + importConfig.getRowIndex() + " ASC LIMIT ?";
    }

    @Override
    public void persist(List<RowData> rowDataList) {
        if (rowDataList == null || rowDataList.isEmpty()) {
            return;
        }
        this.createOrUpdateTableInfo(rowDataList);
        this.insertBatchData(rowDataList);
    }

    @Override
    public int getMaxSheetIndex() {
        int maxSheetIndex = 0;
        Set<String> sheetIndexSet = this.sheetTableInfo.keySet();
        for (String sheetIndexStr : sheetIndexSet) {
            int sheetIndex = Integer.valueOf(sheetIndexStr);
            if (sheetIndex <= maxSheetIndex) continue;
            maxSheetIndex = sheetIndex;
        }
        return maxSheetIndex;
    }

    @Override
    public int getMaxColumnIndex(int sheetIndex) {
        return this.sheetTableInfo.get(String.valueOf(sheetIndex));
    }

    @Override
    public void scan(int sheetIndex, ScanDataHandler scanDataHandler, boolean isAll) {
        String sheetTableName = this.getSheetTableName(sheetIndex);
        Long rowIndex = -1L;
        String sql = String.format(this.scanSqlTemplate, sheetTableName);
        List scannedData = null;
        do {
            try {
                scannedData = this.sqlClient.query(sql, new Object[]{rowIndex, this.importConfig.getScanBatchSize()});
            }
            catch (SQLException e) {
                throw new DataPersistenceException(e);
            }
            if (scannedData.isEmpty()) {
                rowIndex = null;
            } else {
                if (scanDataHandler != null) {
                    ArrayList<List<Object>> result = new ArrayList<List<Object>>();
                    if (isAll) {
                        scannedData.forEach(r -> result.add(Arrays.asList(r)));
                    } else {
                        scannedData.forEach(r -> result.add(Arrays.asList(Arrays.copyOfRange(r, 2, ((Object[])r).length))));
                    }
                    scanDataHandler.handle(sheetIndex, result);
                }
                rowIndex = Long.valueOf(((Object[])scannedData.get(scannedData.size() - 1))[0].toString());
            }
            scannedData.clear();
            scannedData = null;
        } while (rowIndex != null);
    }

    @Override
    public void release() {
        this.sqlClient.close();
        this.sqlClient = null;
        this.sheetTableInfo.clear();
        this.sheetTableInfo = null;
        this.sheetTableInsertSqlTemplate.clear();
        this.sheetTableInsertSqlTemplate = null;
        this.columnLenExtend.clear();
        this.columnLenExtend = null;
        if (this.importConfig.isDeleteStoreFileOnRelease()) {
            File file2;
            File file1 = new File(this.storeFilePath + ".mv.db");
            if (file1.exists()) {
                this.delete(file1);
            }
            if ((file2 = new File(this.storeFilePath + ".trace.db")).exists()) {
                this.delete(file2);
            }
        }
    }

    @Override
    public void setUserInput(int sheetIndex, int rowIndex, String input) {
        String sheetIndexStr;
        int compareLen;
        int userInputLen;
        if (input == null) {
            input = "";
        }
        if ((userInputLen = input.length()) > (compareLen = Optional.ofNullable(this.userInputLenExtend.get(sheetIndexStr = String.valueOf(sheetIndex))).orElse(this.importConfig.getDefaultUserInputLen()).intValue())) {
            this.userInputLenExtend.put(sheetIndexStr, userInputLen);
            this.updateUserInputColumnLen(sheetIndexStr, userInputLen);
        }
        String sheetTableName = this.importConfig.getTablePrefix() + sheetIndex;
        String sql = "UPDATE " + sheetTableName + " SET " + this.importConfig.getRowUserInput() + " = ? WHERE " + this.importConfig.getRowIndex() + " = ?";
        try {
            this.sqlClient.update(sql, new Object[]{input, rowIndex});
        }
        catch (SQLException e) {
            logger.error("setUserInput error", (Throwable)e);
            throw new DataPersistenceException(e);
        }
    }

    private void updateUserInputColumnLen(String sheetIndexStr, int userInputLen) {
        String sheetTableName = this.importConfig.getTablePrefix() + sheetIndexStr;
        String alterDdlTemplate = "ALTER TABLE %s ALTER COLUMN %s VARCHAR(%s)";
        String alterDdl = String.format(alterDdlTemplate, sheetTableName, this.importConfig.getRowUserInput(), userInputLen);
        try {
            this.sqlClient.execute(alterDdl, new Object[0]);
        }
        catch (SQLException e) {
            logger.error("update user input column len error", (Throwable)e);
            throw new DataPersistenceException(e);
        }
    }

    private void delete(File file) {
        boolean deleted = false;
        int tryCount = 3;
        for (int currentCount = 0; currentCount < tryCount; ++currentCount) {
            try {
                Files.delete(file.toPath());
                deleted = true;
            }
            catch (IOException e) {
                logger.error("delete file error", (Throwable)e);
            }
            if (deleted) {
                logger.info(" file delete ok -> {}", (Object)file.getAbsolutePath());
                break;
            }
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private void insertBatchData(List<RowData> rowDataList) {
        RowData rowData = rowDataList.get(0);
        String sheetIndexStr = String.valueOf(rowData.getSheetIndex());
        String insertSqlTemplate = this.parseInsertSqlTemplate(sheetIndexStr);
        List<Object[]> batchParams = this.parseBatchParams(sheetIndexStr, rowDataList);
        logger.info("insertSqlTemplate -> {}", (Object)insertSqlTemplate);
        try {
            this.sqlClient.insertBatch(insertSqlTemplate, batchParams);
        }
        catch (SQLException e) {
            logger.error("insertBatchData error", (Throwable)e);
            throw new DataPersistenceException(e);
        }
    }

    private List<Object[]> parseBatchParams(String sheetIndexStr, List<RowData> rowDataList) {
        int columnSize = this.sheetTableInfo.get(sheetIndexStr);
        int columnSizeAct = columnSize + 2;
        ArrayList<Object[]> batchData = new ArrayList<Object[]>();
        for (RowData row : rowDataList) {
            Object[] rowObject = new Object[columnSizeAct];
            rowObject[0] = row.getRowIndex();
            rowObject[1] = "";
            List<Object> rowCells = row.getRowCells();
            int actDataSize = rowCells.size();
            for (int i = 2; i < columnSizeAct; ++i) {
                rowObject[i] = i - 2 >= actDataSize ? "" : this.convert(row.getSheetIndex(), row.getRowIndex(), i - 2 + 1, rowCells.get(i - 2));
            }
            batchData.add(rowObject);
        }
        return batchData;
    }

    private String convert(int sheetIndex, long rowIndex, int columnIndex, Object object) {
        return ExcelCellValueConverterManager.getExcelCellValueConverter().convert(sheetIndex, rowIndex, columnIndex, object);
    }

    private String parseInsertSqlTemplate(String sheetIndexStr) {
        int i;
        if (this.sheetTableInsertSqlTemplate.containsKey(sheetIndexStr)) {
            return this.sheetTableInsertSqlTemplate.get(sheetIndexStr);
        }
        Integer columnSize = this.sheetTableInfo.get(sheetIndexStr);
        String sheetTableName = this.importConfig.getTablePrefix() + sheetIndexStr;
        StringBuilder sb = new StringBuilder();
        sb.append("INSERT INTO ").append(sheetTableName).append(" ");
        sb.append("(").append(this.importConfig.getRowIndex()).append(",");
        sb.append(this.importConfig.getRowUserInput()).append(",");
        for (i = 1; i <= columnSize; ++i) {
            sb.append(this.importConfig.getColumnPrefix()).append(i).append(",");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(") VALUES (?,?,");
        for (i = 1; i <= columnSize; ++i) {
            sb.append("?,");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(")");
        return sb.toString();
    }

    private String parseInsertSqlTemplate(String sheetIndexStr, Integer columnSize) {
        int i;
        String sheetTableName = this.importConfig.getTablePrefix() + sheetIndexStr;
        StringBuilder sb = new StringBuilder();
        sb.append("INSERT INTO ").append(sheetTableName).append(" ");
        sb.append("(").append(this.importConfig.getRowIndex()).append(",");
        sb.append(this.importConfig.getRowUserInput()).append(",");
        for (i = 1; i <= columnSize; ++i) {
            sb.append(this.importConfig.getColumnPrefix()).append(i).append(",");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(") VALUES (?,?,");
        for (i = 1; i <= columnSize; ++i) {
            sb.append("?,");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(")");
        return sb.toString();
    }

    private void createOrUpdateTableInfo(List<RowData> rowDataList) {
        for (RowData row : rowDataList) {
            String sheetIndexStr = String.valueOf(row.getSheetIndex());
            List<Object> rowCells = row.getRowCells();
            int columnSize = rowCells.size();
            if (!this.sheetTableInfo.containsKey(sheetIndexStr)) {
                this.sheetTableInfo.put(sheetIndexStr, columnSize);
                this.sheetTableInsertSqlTemplate.put(sheetIndexStr, this.parseInsertSqlTemplate(sheetIndexStr, columnSize));
                this.createTable(sheetIndexStr, columnSize);
            } else {
                int sheetColumnSize = this.sheetTableInfo.get(sheetIndexStr);
                if (columnSize > sheetColumnSize) {
                    this.sheetTableInfo.put(sheetIndexStr, columnSize);
                    this.sheetTableInsertSqlTemplate.put(sheetIndexStr, this.parseInsertSqlTemplate(sheetIndexStr, columnSize));
                    this.updateTable(sheetIndexStr, sheetColumnSize, columnSize);
                }
            }
            for (int i = 1; i <= columnSize; ++i) {
                int compareLen;
                String key = sheetIndexStr + "." + i;
                Object cellObject = rowCells.get(i - 1);
                int len = this.convert(row.getSheetIndex(), row.getRowIndex(), i, cellObject).length();
                if (len <= (compareLen = Optional.ofNullable(this.columnLenExtend.get(key)).orElse(this.importConfig.getDefaultLen()).intValue())) continue;
                this.columnLenExtend.put(key, len);
                this.updateColumn(sheetIndexStr, i, len);
            }
        }
    }

    private void updateColumn(String sheetIndexStr, int i, int len) {
        String sheetTableName = this.importConfig.getTablePrefix() + sheetIndexStr;
        String alterDdlTemplate = "ALTER TABLE %s ALTER COLUMN %s VARCHAR(%s)";
        String alterDdl = String.format(alterDdlTemplate, sheetTableName, this.importConfig.getColumnPrefix() + i, len);
        try {
            this.sqlClient.execute(alterDdl, new Object[0]);
        }
        catch (SQLException e) {
            logger.error("update column error", (Throwable)e);
            throw new DataPersistenceException(e);
        }
    }

    private void createTable(String sheetIndexStr, int columnSize) {
        String createDdlTemplate = "CREATE TABLE IF NOT EXISTS %s (" + this.importConfig.getRowIndex() + " BIGINT, " + this.importConfig.getRowUserInput() + " VARCHAR(" + this.importConfig.getDefaultUserInputLen() + "), %s PRIMARY KEY (" + this.importConfig.getRowIndex() + "));";
        String columnDdlTemplate = this.importConfig.getColumnPrefix() + "%s VARCHAR(%s),";
        String sheetTableName = this.importConfig.getTablePrefix() + sheetIndexStr;
        StringBuilder columns = new StringBuilder();
        for (int i = 1; i <= columnSize; ++i) {
            columns.append(String.format(columnDdlTemplate, i, this.importConfig.getDefaultLen()));
        }
        String createDdl = String.format(createDdlTemplate, sheetTableName, columns.toString());
        try {
            this.sqlClient.execute(createDdl, new Object[0]);
        }
        catch (SQLException e) {
            logger.error("createTable error", (Throwable)e);
            throw new DataPersistenceException(e);
        }
    }

    private void updateTable(String sheetIndexStr, int existColumnSize, int extendColumnSize) {
        String sheetTableName = this.importConfig.getTablePrefix() + sheetIndexStr;
        String alterDdlTemplate = "ALTER TABLE %s ADD COLUMN %s VARCHAR(%s)";
        for (int i = 1; i <= extendColumnSize; ++i) {
            if (i <= existColumnSize) continue;
            String alterDdl = String.format(alterDdlTemplate, sheetTableName, this.importConfig.getColumnPrefix() + i, this.importConfig.getDefaultLen());
            try {
                this.sqlClient.execute(alterDdl, new Object[0]);
                continue;
            }
            catch (SQLException e) {
                logger.error("alter table error", (Throwable)e);
                throw new DataPersistenceException(e);
            }
        }
    }

    private SqlClient create(String dbPath) {
        HashMap<String, String> dsMap = new HashMap<String, String>();
        dsMap.put("name", "import-excel-datasource");
        dsMap.put("dbtype", "h2");
        dsMap.put("url", "jdbc:h2:" + dbPath);
        dsMap.put("driver", "org.h2.Driver");
        dsMap.put("username", "");
        dsMap.put("password", "");
        HashMap<String, Object> extConfig = new HashMap<String, Object>();
        extConfig.put("connectionTimeout", 5000L);
        extConfig.put("idleTimeout", 300000L);
        extConfig.put("maxLifetime", 600000L);
        extConfig.put("minimumIdle", 1);
        extConfig.put("maximumPoolSize", 5);
        extConfig.put("validationTimeout", 3000L);
        extConfig.put("connectionTestQuery", "select 1");
        NamedDataSource namedDataSource = DataSourceWrapperFactory.buildDataSource(dsMap, extConfig);
        return new DefaultSqlClientInitializor().initSqlClient(namedDataSource);
    }
}

